/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.serializer.kryo2;

import com.giffing.wicket.spring.boot.context.exceptions.extensions.ExtensionMisconfigurationException;
import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.external.development.springboot.devtools.SpringDevtoolsSerializerConfig;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.serializer.kryo2.WicketSerializerKryo2Properties;
import lombok.Generated;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.pageserializer.kryo2.KryoSerializer;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.serializer.kryo2", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={KryoSerializer.class})
@EnableConfigurationProperties(value={WicketSerializerKryo2Properties.class})
@ConditionalOnMissingBean(value={SpringDevtoolsSerializerConfig.class})
public class WicketSerializerKryo2Config
implements WicketApplicationInitConfiguration {
    private final WicketSerializerKryo2Properties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        ISerializer currentSerializer = webApplication.getFrameworkSettings().getSerializer();
        if (!currentSerializer.getClass().equals(JavaSerializer.class)) {
            throw new ExtensionMisconfigurationException("Kryo2Config: There is already another serializer configured " + String.valueOf(currentSerializer));
        }
        webApplication.getFrameworkSettings().setSerializer((ISerializer)new KryoSerializer());
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public WicketSerializerKryo2Config(WicketSerializerKryo2Properties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

