/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app.classscanner;

import com.giffing.wicket.spring.boot.context.scan.WicketAccessDeniedPage;
import com.giffing.wicket.spring.boot.context.scan.WicketExpiredPage;
import com.giffing.wicket.spring.boot.context.scan.WicketHomePage;
import com.giffing.wicket.spring.boot.context.scan.WicketInternalErrorPage;
import com.giffing.wicket.spring.boot.context.scan.WicketSignInPage;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidate;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassCandidateScanner {
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanFactory beanFactory;
    private final ClassLoader classLoader;
    private final WicketClassCandidatesHolder classCandidates;

    public void postConstruct() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SpringBootApplication.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketHomePage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketSignInPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketAccessDeniedPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketExpiredPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketInternalErrorPage.class));
        for (String basePackage : ClassCandidateScanner.getMappingBasePackages(this.beanFactory)) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            this.classCandidates.getBasePackages().add(basePackage);
            Set beanDefinitions = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : beanDefinitions) {
                Class beanClass;
                try {
                    beanClass = ClassUtils.forName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                if (beanClass.isAnnotationPresent(WicketHomePage.class)) {
                    this.classCandidates.getHomePageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketSignInPage.class)) {
                    this.classCandidates.getSignInPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketAccessDeniedPage.class)) {
                    this.classCandidates.getAccessDeniedPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketExpiredPage.class)) {
                    this.classCandidates.getExpiredPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketInternalErrorPage.class)) {
                    this.classCandidates.getInternalErrorPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (!beanClass.isAnnotationPresent(SpringBootApplication.class)) continue;
                this.classCandidates.setSpringBootMainClass(beanClass);
            }
        }
    }

    private static Collection<String> getMappingBasePackages(BeanFactory beanFactory) {
        try {
            return AutoConfigurationPackages.get((BeanFactory)beanFactory);
        }
        catch (IllegalStateException ex) {
            return Collections.emptyList();
        }
    }

    @Generated
    public ClassCandidateScanner(Environment environment, ResourceLoader resourceLoader, BeanFactory beanFactory, ClassLoader classLoader, WicketClassCandidatesHolder classCandidates) {
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.beanFactory = beanFactory;
        this.classLoader = classLoader;
        this.classCandidates = classCandidates;
    }
}

