/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.repo.RoleRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class RoleRepoExtImpl
implements RoleRepoExt {
    protected final ApplicationEventPublisher publisher;
    protected final DelegationDAO delegationDAO;
    protected final EntityManager entityManager;

    public RoleRepoExtImpl(ApplicationEventPublisher publisher, DelegationDAO delegationDAO, EntityManager entityManager) {
        this.publisher = publisher;
        this.delegationDAO = delegationDAO;
        this.entityManager = entityManager;
    }

    @Override
    public Role save(Role role) {
        ((JPARole)role).list2json();
        return (Role)this.entityManager.merge((Object)role);
    }

    @Override
    public void delete(Role role) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE :role MEMBER OF e.roles", User.class);
        query.setParameter("role", (Object)role);
        query.getResultList().forEach(user -> {
            user.getRoles().remove(role);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)user, AuthContextUtils.getDomain()));
        });
        this.delegationDAO.findByRoles(role).forEach(delegation -> delegation.getRoles().remove(role));
        this.entityManager.remove((Object)role);
    }
}

