/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.GroupTypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractAnyRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroupTypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class GroupRepoExtImpl
extends AbstractAnyRepoExt<Group>
implements GroupRepoExt {
    protected final ApplicationEventPublisher publisher;
    protected final RealmDAO realmDAO;
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;

    public GroupRepoExtImpl(AnyUtilsFactory anyUtilsFactory, ApplicationEventPublisher publisher, PlainSchemaDAO plainSchemaDAO, RealmDAO realmDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, EntityManager entityManager, AnyFinder anyFinder) {
        super(plainSchemaDAO, entityManager, anyFinder, anyUtilsFactory.getInstance(AnyTypeKind.GROUP));
        this.publisher = publisher;
        this.realmDAO = realmDAO;
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
    }

    @Override
    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm) {
        boolean authorized = authRealms.stream().map(authRealm -> RealmUtils.ManagerRealm.of((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(managerRealm -> key.equals(managerRealm.anyKey()));
        if (!authorized) {
            authorized = authRealms.stream().anyMatch(realm::startsWith);
        }
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.GROUP.name(), key);
        }
    }

    @Override
    protected void securityChecks(Group group) {
        Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("GROUP_READ", Set.of());
        this.securityChecks(authRealms, group.getKey(), group.getRealm().getFullPath());
    }

    @Override
    public boolean isManager(String key) {
        Query user = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM SyncopeUser WHERE gManager_id=?");
        user.setParameter(1, (Object)key);
        Query group = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM SyncopeGroup WHERE gManager_id=?");
        group.setParameter(1, (Object)key);
        Query anyObject = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM AnyObject WHERE gManager_id=?");
        anyObject.setParameter(1, (Object)key);
        return ((Number)user.getSingleResult()).longValue() + ((Number)group.getSingleResult()).longValue() + ((Number)anyObject.getSingleResult()).longValue() > 0L;
    }

    @Override
    public List<User> findManagedUsers(String key) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE e.gManager.id=:key", User.class);
        query.setParameter("key", (Object)key);
        return query.getResultList();
    }

    @Override
    public List<Group> findManagedGroups(String key) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAGroup.class.getSimpleName() + " e WHERE e.gManager.id=:key", Group.class);
        query.setParameter("key", (Object)key);
        return query.getResultList();
    }

    @Override
    public List<AnyObject> findManagedAnyObjects(String key) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAAnyObject.class.getSimpleName() + " e WHERE e.gManager.id=:key", AnyObject.class);
        query.setParameter("key", (Object)key);
        return query.getResultList();
    }

    @Override
    public Map<String, Long> countByRealm() {
        Query query = this.entityManager.createQuery("SELECT e.realm, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).longValue()));
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findById(key).map(Any::getResources).orElseGet(List::of).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean existsAMembership(String anyObjectKey, String groupKey) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM AMembership WHERE group_id=? AND anyobject_it=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)anyObjectKey);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean existsUMembership(String userKey, String groupKey) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM UMembership WHERE group_id=? AND user_id=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)userKey);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }

    @Override
    public List<AMembership> findAMemberships(Group group) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAAMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", AMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    @Override
    public List<UMembership> findUMemberships(Group group, Pageable pageable) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group ORDER BY e.leftEnd", UMembership.class);
        query.setParameter("group", (Object)group);
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    @Override
    public <S extends Group> S save(S group) {
        this.checkBeforeSave((JPAGroup)group);
        return (S)((Group)this.entityManager.merge(group));
    }

    @Override
    public void delete(Group group) {
        this.findAMemberships(group).forEach(membership -> {
            AnyObject leftEnd = (AnyObject)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((AnyObject)leftEnd).remove(arg_0));
            this.anyObjectDAO.save((Entity)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.findUMemberships(group, Pageable.unpaged()).forEach(membership -> {
            User leftEnd = (User)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((User)leftEnd).remove(arg_0));
            this.userDAO.save((Entity)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.entityManager.remove((Object)group);
    }

    @Override
    public List<GroupTypeExtension> findTypeExtensions(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAGroupTypeExtension.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.auxClasses", GroupTypeExtension.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }
}

