/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.jpa.dao.SearchViewSupport;

public class SearchSupport {
    protected final AnyTypeKind anyTypeKind;
    protected boolean nonMandatorySchemas = false;

    public SearchSupport(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    public SearchView table() {
        return new SearchView("t", switch (this.anyTypeKind) {
            case AnyTypeKind.ANY_OBJECT -> "AnyObject";
            case AnyTypeKind.GROUP -> "SyncopeGroup";
            default -> "SyncopeUser";
        });
    }

    public SearchView field() {
        return new SearchView("sv", switch (this.anyTypeKind) {
            case AnyTypeKind.ANY_OBJECT -> "anyObject_search";
            case AnyTypeKind.GROUP -> "group_search";
            default -> "user_search";
        });
    }

    public SearchView relationship() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : (this.anyTypeKind == AnyTypeKind.GROUP ? "g" : "a");
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "relationship");
    }

    public SearchView membership() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : "a";
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "membership");
    }

    public SearchView role() {
        return new SearchView("svr", this.field().name + "_role");
    }

    public SearchView auxClass() {
        return new SearchView("svac", this.field().name + "_auxClass");
    }

    public SearchView resource() {
        return new SearchView("svr", this.field().name + "_resource");
    }

    public SearchView groupResource() {
        return new SearchView("svrr", this.field().name + "_group_res");
    }

    public SearchView entitlements() {
        return new SearchView("sve", this.field().name + "_entitlements");
    }

    SearchViewSupport asSearchViewSupport() {
        SearchSupport searchSupport = this;
        if (searchSupport instanceof SearchViewSupport) {
            SearchViewSupport searchViewSupport = (SearchViewSupport)searchSupport;
            return searchViewSupport;
        }
        throw new IllegalArgumentException("Not an " + String.valueOf(SearchViewSupport.class) + " instance");
    }

    public record SearchView(String alias, String name) {
    }
}

