/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.MDC;

public class MDCInInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final String KEY_EXCHANGE_ID = "exchangeId";

    public MDCInInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        String exchangeId = (String)exchange.get((Object)KEY_EXCHANGE_ID);
        if (exchangeId == null) {
            exchangeId = SecureRandomUtils.generateRandomUUID().toString();
            exchange.put((Object)KEY_EXCHANGE_ID, (Object)exchangeId);
        }
        MDC.put((String)"operation.id", (String)exchangeId);
    }
}

