/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.model.core.web.flow.WebflowProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutorResolver;
import org.apereo.cas.web.flow.executor.ClientFlowExecutionKey;
import org.apereo.cas.web.flow.executor.ClientFlowExecutionRepositoryException;
import org.apereo.cas.web.flow.executor.EncryptedTranscoder;
import org.apereo.cas.web.flow.executor.Transcoder;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;

public class ClientFlowExecutionRepository
implements FlowExecutionRepository,
FlowExecutionKeyFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientFlowExecutionRepository.class);
    private static final FlowExecutionLock NOOP_LOCK = new FlowExecutionLock(){

        public void lock() {
        }

        public void unlock() {
        }
    };
    private static final String WEBFLOW_USER_AGENT = ClientFlowExecutionKey.class.getName() + ".userAgent";
    private static final String WEBFLOW_CLIENT_IP_ADDRESS = ClientFlowExecutionKey.class.getName() + ".clientIpAddress";
    private final FlowExecutionFactory flowExecutionFactory;
    private final FlowDefinitionLocator flowDefinitionLocator;
    private final CipherExecutorResolver cipherExecutorResolver;
    private final WebflowProperties webflowProperties;

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        return ClientFlowExecutionKey.parse(encodedKey);
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return NOOP_LOCK;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        if (key instanceof ClientFlowExecutionKey) {
            ClientFlowExecutionKey clientFlowExecutionKey = (ClientFlowExecutionKey)key;
            try {
                byte[] encoded = clientFlowExecutionKey.getData();
                SerializedFlowExecutionState state = (SerializedFlowExecutionState)this.determineTranscoder().decode(encoded);
                if (this.webflowProperties.getSession().isPinToSession()) {
                    this.verifyWebflowSessionIsCorrectlyPinned(state);
                }
                MutableAttributeMap conversationScope = state.getConversationScope();
                FlowDefinition flow = this.flowDefinitionLocator.getFlowDefinition(state.getFlowId());
                return this.flowExecutionFactory.restoreFlowExecution(state.getExecution(), flow, key, conversationScope, this.flowDefinitionLocator);
            }
            catch (Exception e) {
                throw new ClientFlowExecutionRepositoryException("Error decoding flow execution", e);
            }
        }
        throw new IllegalArgumentException("Expected instance of ClientFlowExecutionKey but got " + key.getClass().getName());
    }

    public void putFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
    }

    public void removeFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
    }

    public FlowExecutionKey getKey(FlowExecution execution) {
        try {
            if (this.webflowProperties.getSession().isPinToSession()) {
                this.recordWebflowSessionPinningInfo(execution);
            }
            SerializedFlowExecutionState state = new SerializedFlowExecutionState(execution);
            return new ClientFlowExecutionKey(this.determineTranscoder().encode(state));
        }
        catch (Exception e) {
            throw new ClientFlowExecutionRepositoryException("Error encoding flow execution", e);
        }
    }

    public void updateFlowExecutionSnapshot(FlowExecution execution) {
    }

    public void removeFlowExecutionSnapshot(FlowExecution execution) {
    }

    public void removeAllFlowExecutionSnapshots(FlowExecution execution) {
    }

    protected Transcoder determineTranscoder() {
        ClientInfo clientInfo = Objects.requireNonNull(ClientInfoHolder.getClientInfo(), "Client info cannot be null");
        CipherExecutor cipherExecutor = this.cipherExecutorResolver.resolve(clientInfo.getTenant());
        return new EncryptedTranscoder(cipherExecutor);
    }

    protected void recordWebflowSessionPinningInfo(FlowExecution execution) {
        ClientInfo clientInfo = Objects.requireNonNull(ClientInfoHolder.getClientInfo(), "Client info cannot be null");
        Assert.hasText((String)clientInfo.getUserAgent(), (String)"User-agent cannot be null or empty");
        Assert.hasText((String)clientInfo.getClientIpAddress(), (String)"Client IP address cannot be null or empty");
        execution.getConversationScope().put(WEBFLOW_USER_AGENT, (Object)clientInfo.getUserAgent());
        execution.getConversationScope().put(WEBFLOW_CLIENT_IP_ADDRESS, (Object)clientInfo.getClientIpAddress());
    }

    protected void verifyWebflowSessionIsCorrectlyPinned(SerializedFlowExecutionState state) {
        ClientInfo currentClientInfo = ClientInfoHolder.getClientInfo();
        MutableAttributeMap conversationScope = state.getConversationScope();
        String userAgent = (String)conversationScope.get(WEBFLOW_USER_AGENT);
        String clientIpAddress = (String)conversationScope.get(WEBFLOW_CLIENT_IP_ADDRESS);
        Assert.hasText((String)userAgent, (String)"User-agent cannot be null or empty");
        Assert.hasText((String)clientIpAddress, (String)"Client IP address cannot be null or empty");
        if (!Strings.CI.equals(currentClientInfo.getUserAgent(), userAgent) || !Strings.CI.equals(currentClientInfo.getClientIpAddress(), clientIpAddress)) {
            LOGGER.error("User-agent attached to the webflow [{}] does not match the current user-agent [{}] or client IP address attached to the webflow [{}] does not match the current client IP address [{}]. The flow execution key is invalid or likely tampered with.", new Object[]{userAgent, currentClientInfo.getUserAgent(), clientIpAddress, currentClientInfo.getClientIpAddress()});
            throw new ClientFlowExecutionRepositoryException("Webflow execution key is invalid");
        }
    }

    @Generated
    public ClientFlowExecutionRepository(FlowExecutionFactory flowExecutionFactory, FlowDefinitionLocator flowDefinitionLocator, CipherExecutorResolver cipherExecutorResolver, WebflowProperties webflowProperties) {
        this.flowExecutionFactory = flowExecutionFactory;
        this.flowDefinitionLocator = flowDefinitionLocator;
        this.cipherExecutorResolver = cipherExecutorResolver;
        this.webflowProperties = webflowProperties;
    }

    @Generated
    public FlowExecutionFactory getFlowExecutionFactory() {
        return this.flowExecutionFactory;
    }

    @Generated
    public FlowDefinitionLocator getFlowDefinitionLocator() {
        return this.flowDefinitionLocator;
    }

    public static class SerializedFlowExecutionState
    implements Serializable {
        private static final long serialVersionUID = -4020991769174829876L;
        private final String flowId;
        private final MutableAttributeMap conversationScope;
        private final FlowExecution execution;

        SerializedFlowExecutionState(FlowExecution execution) {
            this.execution = execution;
            this.flowId = execution.getDefinition().getId();
            this.conversationScope = execution.getConversationScope();
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public MutableAttributeMap getConversationScope() {
            return this.conversationScope;
        }

        @Generated
        public FlowExecution getExecution() {
            return this.execution;
        }
    }
}

