/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClient;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.BaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class BaseDelegatedIdentityProviderFactory
implements DelegatedIdentityProviderFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedIdentityProviderFactory.class);
    protected final CasConfigurationProperties casProperties;
    protected final Collection<DelegatedClientFactoryCustomizer> customizers;
    protected final CasSSLContext casSSLContext;
    protected final Cache<String, List<BaseClient>> clientsCache;
    protected final ConfigurableApplicationContext applicationContext;
    private final CasReentrantLock lock = new CasReentrantLock();

    protected abstract List<BaseClient> load() throws Exception;

    public void destroy() throws Exception {
        List<BaseClient> clients = this.retrieve(this.casProperties.getServer().getName());
        Optional.ofNullable(clients).stream().filter(Closeable.class::isInstance).map(Closeable.class::cast).forEach(Unchecked.consumer(Closeable::close));
    }

    public final List<BaseClient> build() {
        return (List)this.lock.tryLock(() -> {
            Pac4jDelegatedAuthenticationCoreProperties core = this.casProperties.getAuthn().getPac4j().getCore();
            List<BaseClient> currentClients = !core.isLazyInit() || this.retrieve(this.casProperties.getServer().getName()).isEmpty() ? this.load() : this.retrieve(this.casProperties.getServer().getName());
            this.store(this.casProperties.getServer().getName(), currentClients);
            return currentClients;
        });
    }

    public void store(String key, List<BaseClient> currentClients) {
        this.clientsCache.put((Object)key, currentClients);
    }

    public List<BaseClient> retrieve(String key) {
        List cachedClients = (List)this.clientsCache.getIfPresent((Object)key);
        return (List)ObjectUtils.getIfNull((Object)cachedClients, new ArrayList());
    }

    public List<BaseClient> rebuild() {
        this.clientsCache.invalidateAll();
        return this.build();
    }

    protected BaseClient configureClient(BaseClient client, Pac4jBaseClientProperties clientProperties, CasConfigurationProperties givenProperties) {
        if (clientProperties != null) {
            DelegatedIdentityProviderFactory.configureClientName((BaseClient)client, (String)clientProperties.getClientName());
            DelegatedIdentityProviderFactory.configureClientCustomProperties((BaseClient)client, (Pac4jBaseClientProperties)clientProperties);
            DelegatedIdentityProviderFactory.configureClientCallbackUrl((BaseClient)client, (Pac4jBaseClientProperties)clientProperties, (String)this.casProperties.getServer().getLoginUrl());
        }
        this.invokeClientCustomizers(client);
        if (!givenProperties.getAuthn().getPac4j().getCore().isLazyInit()) {
            client.init();
        }
        LOGGER.debug("Configured external identity provider [{}]", (Object)client.getName());
        return client;
    }

    protected void invokeClientCustomizers(BaseClient client) {
        this.customizers.forEach(customizer -> customizer.customize(client));
    }

    public List<BaseClient> buildFrom(CasConfigurationProperties properties) throws Exception {
        LinkedHashSet newClients = new LinkedHashSet();
        List<ConfigurableDelegatedClientBuilder> builders = this.getDelegatedClientBuilders();
        for (ConfigurableDelegatedClientBuilder builder : builders) {
            List<ConfigurableDelegatedClient> builtClients = builder.build(properties);
            LOGGER.debug("Builder [{}] provides [{}] clients", (Object)builder.getName(), (Object)builtClients.size());
            builtClients.forEach(Unchecked.consumer(instance -> {
                BaseClient preparedClient = this.configureClient(instance.getClient(), instance.getProperties(), properties);
                List<? extends BaseClient> configuredClients = builder.configure(preparedClient, instance.getProperties(), properties);
                configuredClients.stream().filter(configured -> configured.equals(preparedClient)).forEach(this::invokeClientCustomizers);
                newClients.addAll(configuredClients);
            }));
        }
        return List.copyOf(newClients);
    }

    private List<ConfigurableDelegatedClientBuilder> getDelegatedClientBuilders() {
        ArrayList<ConfigurableDelegatedClientBuilder> builders = new ArrayList<ConfigurableDelegatedClientBuilder>(this.applicationContext.getBeansOfType(ConfigurableDelegatedClientBuilder.class).values());
        AnnotationAwareOrderComparator.sort(builders);
        return builders;
    }

    @Generated
    public BaseDelegatedIdentityProviderFactory(CasConfigurationProperties casProperties, Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, Cache<String, List<BaseClient>> clientsCache, ConfigurableApplicationContext applicationContext) {
        this.casProperties = casProperties;
        this.customizers = customizers;
        this.casSSLContext = casSSLContext;
        this.clientsCache = clientsCache;
        this.applicationContext = applicationContext;
    }
}

