/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import io.swagger.v3.core.util.SchemaTypeUtils;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;

public class ValidationAnnotationsUtils {
    public static final String JAVAX_NOT_NULL = "jakarta.validation.constraints.NotNull";
    public static final String JAVAX_NOT_EMPTY = "jakarta.validation.constraints.NotEmpty";
    public static final String JAVAX_NOT_BLANK = "jakarta.validation.constraints.NotBlank";
    public static final String JAVAX_MIN = "jakarta.validation.constraints.Min";
    public static final String JAVAX_MAX = "jakarta.validation.constraints.Max";
    public static final String JAVAX_SIZE = "jakarta.validation.constraints.Size";
    public static final String JAVAX_DECIMAL_MIN = "jakarta.validation.constraints.DecimalMin";
    public static final String JAVAX_DECIMAL_MAX = "jakarta.validation.constraints.DecimalMax";
    public static final String JAVAX_PATTERN = "jakarta.validation.constraints.Pattern";
    public static final String JAVAX_EMAIL = "jakarta.validation.constraints.Email";
    private static final String SCHEMA_EMAIL_FORMAT_NAME = "email";

    public static boolean applyNotEmptyConstraint(io.swagger.v3.oas.models.media.Schema schema, Schema ctxSchema, ArraySchema ctxArraySchema) {
        if (SchemaTypeUtils.isArraySchema(schema)) {
            if (ctxArraySchema == null || ctxArraySchema.minItems() == Integer.MAX_VALUE) {
                schema.setMinItems(Integer.valueOf(1));
                return true;
            }
        } else if (SchemaTypeUtils.isStringSchema(schema)) {
            if (ctxSchema == null || ctxSchema.minLength() == 0) {
                schema.setMinLength(Integer.valueOf(1));
                return true;
            }
        } else if (SchemaTypeUtils.isObjectSchema(schema) && (ctxSchema == null || ctxSchema.minProperties() == 0)) {
            schema.setMinProperties(Integer.valueOf(1));
            return true;
        }
        return false;
    }

    public static boolean applyNotBlankConstraint(io.swagger.v3.oas.models.media.Schema schema, Schema ctxSchema) {
        if (SchemaTypeUtils.isStringSchema(schema) && (ctxSchema == null || ctxSchema.minLength() == 0)) {
            schema.setMinLength(Integer.valueOf(1));
            return true;
        }
        return false;
    }

    public static boolean applyMinConstraint(io.swagger.v3.oas.models.media.Schema schema, Min annotation) {
        if (SchemaTypeUtils.isNumberSchema(schema)) {
            schema.setMinimum(new BigDecimal(annotation.value()));
            return true;
        }
        return false;
    }

    public static boolean applyMaxConstraint(io.swagger.v3.oas.models.media.Schema schema, Max annotation) {
        if (SchemaTypeUtils.isNumberSchema(schema)) {
            schema.setMaximum(new BigDecimal(annotation.value()));
            return true;
        }
        return false;
    }

    public static boolean applySizeConstraint(io.swagger.v3.oas.models.media.Schema schema, Size annotation) {
        if (SchemaTypeUtils.isNumberSchema(schema)) {
            schema.setMinimum(new BigDecimal(annotation.min()));
            schema.setMaximum(new BigDecimal(annotation.max()));
            return true;
        }
        if (SchemaTypeUtils.isStringSchema(schema)) {
            schema.setMinLength(Integer.valueOf(annotation.min()));
            schema.setMaxLength(Integer.valueOf(annotation.max()));
            return true;
        }
        if (SchemaTypeUtils.isArraySchema(schema)) {
            schema.setMinItems(Integer.valueOf(annotation.min()));
            schema.setMaxItems(Integer.valueOf(annotation.max()));
            return true;
        }
        return false;
    }

    public static boolean applyDecimalMinConstraint(io.swagger.v3.oas.models.media.Schema schema, DecimalMin annotation) {
        if (SchemaTypeUtils.isNumberSchema(schema)) {
            schema.setMinimum(new BigDecimal(annotation.value()));
            schema.setExclusiveMinimum(Boolean.valueOf(!annotation.inclusive()));
            return true;
        }
        return false;
    }

    public static boolean applyDecimalMaxConstraint(io.swagger.v3.oas.models.media.Schema schema, DecimalMax annotation) {
        if (SchemaTypeUtils.isNumberSchema(schema)) {
            schema.setMaximum(new BigDecimal(annotation.value()));
            schema.setExclusiveMaximum(Boolean.valueOf(!annotation.inclusive()));
            return true;
        }
        return false;
    }

    public static boolean applyPatternConstraint(io.swagger.v3.oas.models.media.Schema schema, Pattern annotation) {
        if (SchemaTypeUtils.isStringSchema(schema)) {
            schema.setPattern(annotation.regexp());
            return true;
        }
        if (schema.getItems() != null && SchemaTypeUtils.isStringSchema(schema.getItems())) {
            schema.getItems().setPattern(annotation.regexp());
            return true;
        }
        return false;
    }

    public static boolean applyEmailConstraint(io.swagger.v3.oas.models.media.Schema schema, Email annotation) {
        if (SchemaTypeUtils.isStringSchema(schema)) {
            schema.setFormat(SCHEMA_EMAIL_FORMAT_NAME);
            return true;
        }
        if (schema.getItems() != null && SchemaTypeUtils.isStringSchema(schema.getItems())) {
            schema.getItems().setFormat(SCHEMA_EMAIL_FORMAT_NAME);
            return true;
        }
        return false;
    }
}

