/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;

public class AggregateCasThemeSource
extends ResourceBundleThemeSource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateCasThemeSource.class);
    private final CasConfigurationProperties casProperties;

    @Nonnull
    protected MessageSource createMessageSource(@Nonnull String basename) {
        StaticMessageSource source = new StaticMessageSource();
        source.setParentMessageSource(super.createMessageSource(basename));
        this.casProperties.getView().getTemplatePrefixes().stream().map(prefix -> Strings.CI.appendIfMissing(prefix, (CharSequence)"/", new CharSequence[0]).concat(basename).concat(".properties")).filter(ResourceUtils::doesResourceExist).forEach(path -> {
            try (InputStream is = ResourceUtils.getRawResourceFrom((String)path).getInputStream();){
                Properties properties = new Properties();
                properties.load(is);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    LOGGER.trace("Loading theme property [{}] from [{}]", key, path);
                    source.addMessage(key.toString(), Locale.ENGLISH, value.toString());
                }));
            }
            catch (IOException e) {
                LOGGER.warn("Error loading resources from bundle: [{}] - [{}]", path, (Object)e.getMessage());
            }
        });
        return source;
    }

    @Generated
    public AggregateCasThemeSource(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

