/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import java.util.Map;
import java.util.function.Function;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class VariableScopeResolver
implements Resolver {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected VariableContainer scopeContainer;
    protected VariableContainer inputVariableContainer;
    protected String variableScopeKey = "execution";
    protected static final Map<String, Function<ProcessEngineConfiguration, ?>> SERVICE_RESOLVERS = Map.of("processEngineConfiguration", Function.identity(), "runtimeService", ProcessEngineConfiguration::getRuntimeService, "taskService", ProcessEngineConfiguration::getTaskService, "repositoryService", ProcessEngineConfiguration::getRepositoryService, "managementService", ProcessEngineConfiguration::getManagementService, "historyService", ProcessEngineConfiguration::getHistoryService, "formService", ProcessEngineConfiguration::getFormService, "identityServiceKey", ProcessEngineConfiguration::getIdentityService);

    public VariableScopeResolver(ProcessEngineConfigurationImpl processEngineConfiguration, VariableContainer scopeContainer, VariableContainer inputVariableContainer) {
        this.processEngineConfiguration = processEngineConfiguration;
        if (scopeContainer == null) {
            throw new FlowableIllegalArgumentException("scopeContainer cannot be null");
        }
        if (scopeContainer instanceof ExecutionEntity) {
            this.variableScopeKey = "execution";
        } else if (scopeContainer instanceof TaskEntity) {
            this.variableScopeKey = "task";
        } else {
            throw new FlowableException("unsupported variable scope type: " + scopeContainer.getClass().getName());
        }
        this.scopeContainer = scopeContainer;
        this.inputVariableContainer = inputVariableContainer;
    }

    public boolean containsKey(Object key) {
        return this.variableScopeKey.equals(key) || this.inputVariableContainer.hasVariable((String)key) || SERVICE_RESOLVERS.containsKey(key) && this.processEngineConfiguration.isServicesEnabledInScripting();
    }

    public Object get(Object key) {
        if (this.variableScopeKey.equals(key)) {
            return this.scopeContainer;
        }
        if (SERVICE_RESOLVERS.containsKey((String)key)) {
            if (this.processEngineConfiguration.isServicesEnabledInScripting()) {
                return SERVICE_RESOLVERS.get(key).apply(this.processEngineConfiguration);
            }
            throw new FlowableException("The service '" + String.valueOf(key) + "' is not available in the current context. Please enable services in scripting.");
        }
        return this.inputVariableContainer.getVariable((String)key);
    }
}

