/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiOAuth2Config;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiResourceLocator;

@Path(value="api-docs")
public class SwaggerUiService {
    private static final String FAVICON = "favicon";
    private static final Map<String, String> DEFAULT_MEDIA_TYPES;
    private static final Pattern URL_PATTERN;
    private final SwaggerUiResourceLocator locator;
    private final Map<String, String> mediaTypes;
    private SwaggerUiConfig config;

    public SwaggerUiService(SwaggerUiResourceLocator locator, Map<String, String> mediaTypes) {
        this.locator = locator;
        this.mediaTypes = mediaTypes;
    }

    public void setConfig(SwaggerUiConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{resource:.*}")
    public Response getResource(@Context UriInfo uriInfo, @PathParam(value="resource") String resourcePath) {
        if (resourcePath.contains(FAVICON)) {
            return Response.status((int)404).build();
        }
        try {
            URL resourceURL = this.locator.locate(resourcePath);
            String path = resourceURL.getPath();
            String mediaType = null;
            int ind = path.lastIndexOf(46);
            if (ind != -1 && ind < path.length()) {
                String resourceExt = path.substring(ind + 1);
                mediaType = this.mediaTypes != null && this.mediaTypes.containsKey(resourceExt) ? this.mediaTypes.get(resourceExt) : DEFAULT_MEDIA_TYPES.get(resourceExt);
            }
            if (this.config != null) {
                Map<String, String> params;
                if (path.endsWith("/index.html") && uriInfo.getQueryParameters().isEmpty() && (params = this.config.getConfigParameters()) != null && !params.isEmpty()) {
                    UriBuilder builder = params.entrySet().stream().reduce(uriInfo.getRequestUriBuilder(), (b, e) -> b.queryParam((String)e.getKey(), new Object[]{e.getValue()}), (left, right) -> left);
                    return Response.temporaryRedirect((URI)builder.build(new Object[0])).build();
                }
                if (path.endsWith("/index.html") || path.endsWith("/swagger-initializer.js")) {
                    String url = this.config.getUrl();
                    SwaggerUiOAuth2Config oAuthConfig = this.config.getOAuth2Config();
                    if (!StringUtils.isEmpty((String)url) || oAuthConfig != null) {
                        try (InputStream in = resourceURL.openStream();){
                            String resource = IOUtils.readStringFromStream((InputStream)in);
                            if (!StringUtils.isEmpty((String)url) && !Boolean.TRUE.equals(this.config.isQueryConfigEnabled())) {
                                resource = this.replaceUrl(resource, url);
                            }
                            if (path.endsWith("/swagger-initializer.js") && oAuthConfig != null) {
                                resource = this.addOAuth2Init(resource, oAuthConfig);
                            }
                            Response.ResponseBuilder rb = Response.ok((Object)resource);
                            if (mediaType != null) {
                                rb.type(mediaType);
                            }
                            Response response = rb.build();
                            return response;
                        }
                    }
                }
            }
            Response.ResponseBuilder rb = Response.ok((Object)resourceURL.openStream());
            if (mediaType == null) return rb.build();
            rb.type(mediaType);
            return rb.build();
        }
        catch (IOException ex) {
            throw new NotFoundException((Throwable)ex);
        }
    }

    protected String replaceUrl(String index, String replacement) {
        Matcher matcher = URL_PATTERN.matcher(index);
        if (matcher.find()) {
            return index.substring(0, matcher.start(1)) + replacement + index.substring(matcher.end(1));
        }
        return index;
    }

    protected String addOAuth2Init(String original, SwaggerUiOAuth2Config oAuth2Config) {
        int startSwaggerConstructIndex = original.indexOf("SwaggerUIBundle({");
        if (startSwaggerConstructIndex < 0) {
            return original;
        }
        int endSwaggerConstructIndex = original.indexOf("});", startSwaggerConstructIndex);
        if (endSwaggerConstructIndex < 0) {
            return original;
        }
        String initJs = "\n  ui.initOAuth(" + oAuth2Config.toJsonString() + ")\n";
        return original.substring(0, endSwaggerConstructIndex += 3) + initJs + original.substring(endSwaggerConstructIndex);
    }

    static {
        URL_PATTERN = Pattern.compile("url[:]\\s*[\"]([^\"]+)[\"][,]");
        DEFAULT_MEDIA_TYPES = new HashMap<String, String>();
        DEFAULT_MEDIA_TYPES.put("html", "text/html");
        DEFAULT_MEDIA_TYPES.put("png", "image/png");
        DEFAULT_MEDIA_TYPES.put("gif", "image/gif");
        DEFAULT_MEDIA_TYPES.put("css", "text/css");
        DEFAULT_MEDIA_TYPES.put("js", "application/javascript");
        DEFAULT_MEDIA_TYPES.put("eot", "application/vnd.ms-fontobject");
        DEFAULT_MEDIA_TYPES.put("ttf", "application/font-sfnt");
        DEFAULT_MEDIA_TYPES.put("svg", "image/svg+xml");
        DEFAULT_MEDIA_TYPES.put("woff", "application/font-woff");
        DEFAULT_MEDIA_TYPES.put("woff2", "application/font-woff2");
    }
}

