/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.mgmr;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutorResolver;
import org.apereo.cas.web.cookie.CookieSameSitePolicy;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedCookieValueManager
implements CookieValueManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedCookieValueManager.class);
    private static final long serialVersionUID = 6362136147071376270L;
    private final CipherExecutorResolver cipherExecutorResolver;
    private final TenantExtractor tenantExtractor;
    private final CookieSameSitePolicy cookieSameSitePolicy;

    public final String buildCookieValue(String givenCookieValue, HttpServletRequest request) {
        String cookieValue = this.buildCompoundCookieValue(givenCookieValue, request);
        LOGGER.trace("Encoding cookie value [{}]", (Object)cookieValue);
        return ((Serializable)this.determineCipherExecutor(request).encode((Object)cookieValue, ArrayUtils.EMPTY_OBJECT_ARRAY)).toString();
    }

    public String obtainCookieValue(String cookie, HttpServletRequest request) {
        Serializable decoded = (Serializable)this.determineCipherExecutor(request).decode((Object)cookie, ArrayUtils.EMPTY_OBJECT_ARRAY);
        if (decoded == null) {
            LOGGER.trace("Could not decode cookie value [{}] for cookie", (Object)cookie);
            return null;
        }
        String cookieValue = decoded.toString();
        LOGGER.trace("Decoded cookie value is [{}]", (Object)cookieValue);
        if (StringUtils.isBlank((CharSequence)cookieValue)) {
            LOGGER.trace("Retrieved decoded cookie value is blank. Failed to decode cookie");
            return null;
        }
        return this.obtainValueFromCompoundCookie(cookieValue, request);
    }

    protected String buildCompoundCookieValue(String cookieValue, HttpServletRequest request) {
        return cookieValue;
    }

    protected String obtainValueFromCompoundCookie(String compoundValue, HttpServletRequest request) {
        return compoundValue;
    }

    protected CipherExecutor<Serializable, Serializable> determineCipherExecutor(HttpServletRequest request) {
        return this.cipherExecutorResolver.resolve(request);
    }

    @Generated
    public EncryptedCookieValueManager(CipherExecutorResolver cipherExecutorResolver, TenantExtractor tenantExtractor, CookieSameSitePolicy cookieSameSitePolicy) {
        this.cipherExecutorResolver = cipherExecutorResolver;
        this.tenantExtractor = tenantExtractor;
        this.cookieSameSitePolicy = cookieSameSitePolicy;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public CookieSameSitePolicy getCookieSameSitePolicy() {
        return this.cookieSameSitePolicy;
    }
}

