/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.RestPrincipalAttributesProperties;
import org.apereo.cas.persondir.RestfulPersonAttributeDao;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public final class PersonDirectoryUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonDirectoryUtils.class);

    public static List<? extends PersonAttributeDao> newRestAttributeRepository(List<RestPrincipalAttributesProperties> properties) {
        return properties.stream().filter(rest -> StringUtils.hasText((String)rest.getUrl())).map(rest -> {
            RestfulPersonAttributeDao dao = new RestfulPersonAttributeDao();
            dao.setOrder(rest.getOrder());
            FunctionUtils.doIfNotNull((Object)rest.getId(), id -> dao.setId(new String[]{id}));
            dao.setUrl(rest.getUrl());
            dao.setMethod(Objects.requireNonNull(HttpMethod.valueOf((String)rest.getMethod())).name());
            dao.setEnabled(rest.getState() != AttributeRepositoryStates.DISABLED);
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
            headers.putAll(rest.getHeaders());
            dao.setHeaders(headers);
            dao.setUsernameAttributeProvider((UsernameAttributeProvider)new SimpleUsernameAttributeProvider(rest.getUsernameAttribute()));
            dao.putTag("state", rest.getState());
            if (StringUtils.hasText((String)rest.getBasicAuthPassword()) && StringUtils.hasText((String)rest.getBasicAuthUsername())) {
                dao.setBasicAuthPassword(rest.getBasicAuthPassword());
                dao.setBasicAuthUsername(rest.getBasicAuthUsername());
                LOGGER.debug("Basic authentication credentials are located for REST endpoint [{}]", (Object)rest.getUrl());
            } else {
                LOGGER.debug("Basic authentication credentials are not defined for REST endpoint [{}]", (Object)rest.getUrl());
            }
            return dao;
        }).toList();
    }

    @Generated
    private PersonDirectoryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

