/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.locator;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.support.saml.idp.metadata.locator.AbstractSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

@Monitorable
public class FileSystemSamlIdPMetadataLocator
extends AbstractSamlIdPMetadataLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSamlIdPMetadataLocator.class);
    private final File metadataLocation;

    public FileSystemSamlIdPMetadataLocator(CipherExecutor cipherExecutor, Resource resource, Cache<String, SamlIdPMetadataDocument> metadataCache, ConfigurableApplicationContext applicationContext) throws Exception {
        this(cipherExecutor, resource.getFile(), metadataCache, applicationContext);
    }

    public FileSystemSamlIdPMetadataLocator(CipherExecutor cipherExecutor, File resource, Cache<String, SamlIdPMetadataDocument> metadataCache, ConfigurableApplicationContext applicationContext) {
        super((CipherExecutor<String, String>)cipherExecutor, metadataCache, (ApplicationContext)applicationContext);
        this.metadataLocation = resource;
    }

    @Override
    public Resource resolveSigningCertificate(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.getMetadataArtifact(registeredService, "idp-signing.crt");
    }

    @Override
    public Resource resolveSigningKey(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.getMetadataArtifact(registeredService, "idp-signing.key");
    }

    @Override
    public Resource resolveMetadata(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.getMetadataArtifact(registeredService, "idp-metadata.xml");
    }

    @Override
    public Resource resolveEncryptionCertificate(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.getMetadataArtifact(registeredService, "idp-encryption.crt");
    }

    @Override
    public Resource resolveEncryptionKey(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.getMetadataArtifact(registeredService, "idp-encryption.key");
    }

    @Override
    public boolean exists(Optional<SamlRegisteredService> registeredService) throws Throwable {
        return this.resolveMetadata(registeredService).exists();
    }

    @Override
    public void initialize() {
        this.initializeMetadataDirectory();
        LOGGER.info("Metadata directory location is at [{}]", (Object)this.metadataLocation);
    }

    @Override
    protected SamlIdPMetadataDocument fetchInternal(Optional<SamlRegisteredService> registeredService) throws Exception {
        return (SamlIdPMetadataDocument)FunctionUtils.doUnchecked(() -> {
            SamlIdPMetadataDocument doc = new SamlIdPMetadataDocument();
            try (InputStream in = this.resolveMetadata(registeredService).getInputStream();){
                doc.setMetadata(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            in = this.resolveEncryptionCertificate(registeredService).getInputStream();
            try {
                doc.setEncryptionCertificate(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            in = this.resolveEncryptionKey(registeredService).getInputStream();
            try {
                doc.setEncryptionKey(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            in = this.resolveSigningCertificate(registeredService).getInputStream();
            try {
                doc.setSigningCertificate(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            in = this.resolveSigningKey(registeredService).getInputStream();
            try {
                doc.setSigningKey(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            doc.setAppliesTo(this.getAppliesToFor(registeredService));
            return doc;
        });
    }

    protected Resource getMetadataArtifact(Optional<SamlRegisteredService> registeredService, String artifactName) throws Throwable {
        if (registeredService.isPresent()) {
            SamlRegisteredService samlRegisteredService = registeredService.get();
            File serviceDirectory = StringUtils.isNotBlank((CharSequence)samlRegisteredService.getIdpMetadataLocation()) ? ResourceUtils.getRawResourceFrom((String)SpringExpressionLanguageValueResolver.getInstance().resolve(samlRegisteredService.getIdpMetadataLocation())).getFile() : new File(this.metadataLocation, this.getAppliesToFor(registeredService));
            LOGGER.debug("Metadata directory location for [{}] is [{}]", (Object)samlRegisteredService.getName(), (Object)serviceDirectory);
            if (serviceDirectory.exists()) {
                File artifact = new File(serviceDirectory, artifactName);
                LOGGER.trace("Artifact location for [{}] and [{}] is [{}]", new Object[]{artifactName, samlRegisteredService.getName(), artifact});
                if (artifact.exists()) {
                    LOGGER.debug("Using metadata artifact [{}] at [{}]", (Object)artifactName, (Object)artifact);
                    return ResourceUtils.toFileSystemResource((File)artifact);
                }
            }
        }
        this.initializeMetadataDirectory();
        Resource resource = ResourceUtils.toFileSystemResource((File)new File(this.metadataLocation, artifactName));
        if (resource.exists() && resource.isReadable()) {
            String content = FileUtils.readFileToString((File)resource.getFile(), (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                return this.resolveContentToResource(content);
            }
            LOGGER.warn("Metadata artifact at [{}] is empty and invalid and will be deleted", (Object)resource);
            FileUtils.deleteQuietly((File)resource.getFile());
        }
        return ResourceUtils.toFileSystemResource((File)resource.getFile());
    }

    protected void initializeMetadataDirectory() {
        if (!this.metadataLocation.exists()) {
            LOGGER.debug("Metadata directory [{}] does not exist. Creating...", (Object)this.metadataLocation);
            if (!this.metadataLocation.mkdir()) {
                throw new IllegalArgumentException("Metadata directory location " + String.valueOf(this.metadataLocation) + " cannot be located/created");
            }
        }
    }

    @Generated
    public File getMetadataLocation() {
        return this.metadataLocation;
    }
}

