/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.List;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AuthProfileLogic
extends AbstractAuthProfileLogic {
    public AuthProfileLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        super(binder, authProfileDAO, entityFactory);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_LIST')")
    @Transactional(readOnly=true)
    public Page<AuthProfileTO> search(String keyword, Pageable pageable) {
        long count = this.authProfileDAO.countByOwnerLike(keyword);
        List<AuthProfileTO> result = this.authProfileDAO.findByOwnerLike(keyword, pageable).stream().map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_READ') ")
    @Transactional(readOnly=true)
    public AuthProfileTO read(String key) {
        return this.authProfileDAO.findById(key).map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).orElseThrow(() -> new NotFoundException("AuthProfile " + key));
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    @Transactional(readOnly=true)
    public AuthProfileTO selfRead() {
        return this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).orElseThrow(() -> new NotFoundException("AuthProfile for " + AuthContextUtils.getUsername()));
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_CREATE') ")
    public AuthProfileTO create(AuthProfileTO authProfileTO) {
        return this.binder.getAuthProfileTO((AuthProfile)this.authProfileDAO.save((Entity)this.binder.create(authProfileTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_UPDATE') ")
    public void update(AuthProfileTO authProfileTO) {
        AuthProfile authProfile = (AuthProfile)this.authProfileDAO.findById(authProfileTO.getKey()).orElseThrow(() -> new NotFoundException("AuthProfile " + authProfileTO.getKey()));
        this.binder.update(authProfile, authProfileTO);
        this.authProfileDAO.save((Entity)authProfile);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void selfUpdate(AuthProfileTO authProfileTO) {
        this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).filter(authProfile -> authProfile.getKey().equals(authProfileTO.getKey()) && authProfile.getOwner().equals(authProfileTO.getOwner())).orElseThrow(() -> new DelegatedAdministrationException(AnyTypeKind.USER, authProfileTO.getOwner()));
        this.update(authProfileTO);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_DELETE') ")
    public void delete(String key) {
        this.authProfileDAO.deleteById(key);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void selfDelete() {
        this.authProfileDAO.deleteById(((AuthProfile)this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new DelegatedAdministrationException(AnyTypeKind.USER, AuthContextUtils.getUsername()))).getKey());
    }
}

