/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.AnyPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;

abstract class AbstractPullExecutor<T extends ProvisioningTask<T>>
extends AbstractProvisioningJobDelegate<T>
implements SyncopePullExecutor {
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected PlainAttrValidationManager validator;
    @Autowired
    protected ConfigurableApplicationContext ctx;
    protected final Map<String, SyncToken> latestSyncTokens = Collections.synchronizedMap(new HashMap());
    private final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();
    protected final Map<String, InboundActions> perContextActions = new ConcurrentHashMap<String, InboundActions>();
    protected ProvisionSorter provisionSorter;
    protected ProvisioningProfile<PullTask, InboundActions> profile;
    protected PullResultHandlerDispatcher dispatcher;

    AbstractPullExecutor() {
    }

    protected PullResultHandlerDispatcher buildDispatcher() {
        return ((PullResultHandlerDispatcher)this.ctx.getBeanFactory().createBean(PullResultHandlerDispatcher.class)).init(this.profile, this);
    }

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)this.ctx.getBeanFactory().createBean(DefaultRealmPullResultHandler.class);
    }

    protected AnyPullResultHandler buildAnyObjectHandler() {
        return (AnyPullResultHandler)this.ctx.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class);
    }

    protected AnyPullResultHandler buildUserHandler() {
        return (AnyPullResultHandler)this.ctx.getBeanFactory().createBean(DefaultUserPullResultHandler.class);
    }

    protected AnyPullResultHandler buildGroupHandler() {
        return (AnyPullResultHandler)this.ctx.getBeanFactory().createBean(DefaultGroupPullResultHandler.class);
    }

    protected List<InboundActions> getInboundActions(List<? extends Implementation> impls) {
        ArrayList<InboundActions> result = new ArrayList<InboundActions>();
        impls.forEach(impl -> {
            try {
                result.add((InboundActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (InboundActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    @Override
    protected void init(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        this.provisionSorter = this.getProvisionSorter((ProvisioningTask)this.task);
        this.latestSyncTokens.clear();
    }

    public void setLatestSyncToken(String objectClass, SyncToken latestSyncToken) {
        this.latestSyncTokens.put(objectClass, latestSyncToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHandled(String objectClass, Name name) {
        Map<String, MutablePair<Integer, String>> map = this.handled;
        synchronized (map) {
            MutablePair pair = Optional.ofNullable(this.handled.get(objectClass)).orElseGet(() -> {
                MutablePair p = MutablePair.of((Object)0, null);
                this.handled.put(objectClass, (MutablePair<Integer, String>)p);
                return p;
            });
            pair.setLeft((Object)((Integer)pair.getLeft() + 1));
            pair.setRight((Object)name.getNameValue());
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((k, v) -> builder.append(' ').append(v.getLeft()).append('\t').append((String)k).append(" / latest: ").append((String)v.getRight()).append('\n'));
                this.setStatus(builder.toString());
            }
        }
    }
}

