/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class SyncopeTaskScheduler {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeTaskScheduler.class);
    protected final TaskScheduler scheduler;
    protected final JobStatusDAO jobStatusDAO;
    protected final Map<Key, Value> jobs = new ConcurrentHashMap<Key, Value>();

    public SyncopeTaskScheduler(TaskScheduler scheduler, JobStatusDAO jobStatusDAO) {
        this.scheduler = scheduler;
        this.jobStatusDAO = jobStatusDAO;
    }

    protected void register(Job job, ScheduledFuture<?> instant, ScheduledFuture<?> cron) {
        Key key = new Key(job.getContext().getDomain(), job.getContext().getJobName());
        this.stop(key, instant == null ? List.of(Value::cron) : List.of(Value::instant));
        AuthContextUtils.runAsAdmin((String)key.domain(), () -> this.jobStatusDAO.unlock(key.job()));
        this.jobs.merge(key, new Value(job, Optional.ofNullable(instant), Optional.ofNullable(cron)), (prev, value) -> new Value(job, value.instant().isEmpty() ? prev.instant() : value.instant(), value.cron().isEmpty() ? prev.cron() : value.cron()));
    }

    public void register(Job job) {
        this.register(job, null, null);
    }

    public void schedule(Job job, Instant startTime) {
        this.register(job, this.scheduler.schedule((Runnable)job, startTime), null);
    }

    public void schedule(Job job, CronTrigger trigger) {
        this.register(job, null, this.scheduler.schedule((Runnable)job, (Trigger)trigger));
    }

    public void start(String domain, String jobName) {
        Optional.ofNullable(this.jobs.get(new Key(domain, jobName))).filter(value -> value.instant().map(Future::isDone).orElse(true)).ifPresent(value -> this.register(value.job(), this.scheduler.schedule((Runnable)value.job(), Instant.now()), value.cron().orElse(null)));
    }

    protected void stop(Key key, List<Function<Value, Optional<ScheduledFuture<?>>>> suppliers) {
        Optional.ofNullable(this.jobs.get(key)).ifPresent(value -> {
            boolean mayInterruptIfRunning;
            TaskJob taskJob;
            SchedTaskJobDelegate patt1$temp;
            Job patt0$temp = value.job();
            if (patt0$temp instanceof TaskJob && (patt1$temp = (taskJob = (TaskJob)patt0$temp).getDelegate()) instanceof StoppableSchedTaskJobDelegate) {
                StoppableSchedTaskJobDelegate stoppable = (StoppableSchedTaskJobDelegate)patt1$temp;
                stoppable.stop();
                mayInterruptIfRunning = false;
            } else {
                mayInterruptIfRunning = true;
            }
            suppliers.forEach(s -> ((Optional)s.apply(value)).ifPresent(f -> f.cancel(mayInterruptIfRunning)));
        });
    }

    public void stop(String domain, String jobName) {
        this.stop(new Key(domain, jobName), List.of(Value::instant, Value::cron));
    }

    public void delete(String domain, String jobName) {
        this.jobs.remove(new Key(domain, jobName));
        AuthContextUtils.runAsAdmin((String)domain, () -> this.jobStatusDAO.unlock(jobName));
    }

    public Optional<Class<?>> getJobClass(String domain, String jobName) {
        return Optional.ofNullable(this.jobs.get(new Key(domain, jobName))).map(value -> AopUtils.getTargetClass((Object)value.job()));
    }

    public Optional<OffsetDateTime> getNextTrigger(String domain, String jobName) {
        Value value = this.jobs.get(new Key(domain, jobName));
        if (value == null) {
            return Optional.empty();
        }
        ScheduledFuture future = value.cron().filter(f -> !f.isDone()).orElse(null);
        if (future == null) {
            future = value.instant().filter(f -> !f.isDone()).orElse(null);
        }
        if (future == null) {
            return Optional.empty();
        }
        long delay = future.getDelay(TimeUnit.SECONDS);
        if (delay > 0L) {
            return Optional.of(OffsetDateTime.now().plusSeconds(delay));
        }
        return Optional.empty();
    }

    public List<String> getJobNames(String domain) {
        return this.jobs.keySet().stream().filter(key -> domain.equals(key.domain())).map(Key::job).toList();
    }

    public Map<Key, Value> getJobs() {
        return Map.copyOf(this.jobs);
    }

    public record Key(String domain, String job) {
    }

    public record Value(Job job, Optional<ScheduledFuture<?>> instant, Optional<ScheduledFuture<?>> cron) {
    }
}

