/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorAuthorizeTokenAttemptAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorAuthorizeTokenAttemptAction.class);
    private static final String FLOW_SCOPE_ATTEMPT_COUNTER = "GoogleAuthenticatorTokenAttemptCount";
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        int maxAllowedAttempts = this.casProperties.getAuthn().getMfa().getGauth().getCore().getMaximumAuthenticationAttempts();
        Credential credential = Objects.requireNonNull(WebUtils.getCredential((RequestContext)requestContext));
        Integer attemptCounter = (Integer)requestContext.getFlowScope().get(FLOW_SCOPE_ATTEMPT_COUNTER, Integer.class, (Object)0);
        LOGGER.debug("Attempt counter for token [{}] is [{}]", (Object)credential.getId(), (Object)attemptCounter);
        if (maxAllowedAttempts <= 0 || attemptCounter < maxAllowedAttempts) {
            LOGGER.debug("Token [{}] is allowed to proceed with authentication", (Object)credential.getId());
            Integer n = attemptCounter;
            attemptCounter = attemptCounter + 1;
            requestContext.getFlowScope().put(FLOW_SCOPE_ATTEMPT_COUNTER, (Object)attemptCounter);
            return this.success(attemptCounter);
        }
        LOGGER.warn("Token [{}] has exceeded the maximum number of attempts [{}]", (Object)credential.getId(), (Object)attemptCounter);
        return this.error();
    }

    @Generated
    public GoogleAuthenticatorAuthorizeTokenAttemptAction(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

