/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.metadata.CasConfigurationMetadataCatalog;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.metadata.CasConfigurationPropertyBindingResult;
import org.apereo.cas.metadata.ConfigurationMetadataCatalogQuery;
import org.apereo.cas.metadata.DeprecatedElementsBindHandler;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.MutablePropertySources;

public class CasConfigurationPropertiesValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationPropertiesValidator.class);
    public static final String SYSTEM_PROPERTY_CONFIG_VALIDATION_ENABLED = "VALIDATE_CONFIGURATION_ENABLED";
    private final ConfigurableApplicationContext applicationContext;
    private List<Class> configurationPropertyClasses = CollectionUtils.wrapList((Object[])new Class[]{CasConfigurationProperties.class});

    public List<CasConfigurationPropertyBindingResult> validate() {
        boolean validate;
        String propertyValue = System.getProperty(SYSTEM_PROPERTY_CONFIG_VALIDATION_ENABLED);
        boolean bl = validate = StringUtils.isBlank((CharSequence)propertyValue) || BooleanUtils.toBoolean((String)propertyValue);
        if (validate) {
            LOGGER.info("Validating CAS property sources and configuration for active profiles [{}]. Please wait...", (Object)Arrays.toString(this.applicationContext.getEnvironment().getActiveProfiles()));
            List<CasConfigurationPropertyBindingResult> validationResults = this.validateCasConfiguration();
            if (validationResults.isEmpty()) {
                LOGGER.info("Validated CAS property sources and configuration successfully.");
            } else {
                String unknownProperties = validationResults.stream().filter(result -> result.status() == CasConfigurationPropertyBindingResult.BindingStatus.UNKNOWN).map(CasConfigurationPropertyBindingResult::toString).collect(Collectors.joining("\n"));
                if (!unknownProperties.isEmpty()) {
                    String message = "The following settings are not recognized by CAS {}. They may have been renamed, removed, or relocated to a new namespace in the CAS configuration schema. CAS will ignore such settings to proceed with its normal initialization sequence. Please consult the CAS documentation to review and adjust each setting to find an alternative or remove the definition from the property source. Failure to do so puts the server stability in danger and complicates future upgrades.\n{}\n".stripIndent().stripLeading();
                    LOGGER.error(message, (Object)CasVersion.getVersion(), (Object)unknownProperties);
                }
            }
            return validationResults;
        }
        LOGGER.info("CAS configuration validation is explicitly disabled. No validation will be performed.");
        return List.of();
    }

    private List<CasConfigurationPropertyBindingResult> validateCasConfiguration() {
        return (List)FunctionUtils.doAndHandle(() -> this.configurationPropertyClasses.stream().map(this::validateConfiguration).flatMap(Collection::stream).toList());
    }

    private List<CasConfigurationPropertyBindingResult> validateConfiguration(Class clazz) {
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), (Class)clazz);
        MutablePropertySources propertySources = this.applicationContext.getEnvironment().getPropertySources();
        ConfigurableConversionService conversionService = this.applicationContext.getEnvironment().getConversionService();
        DeprecatedElementsBindHandler deprecatedHandler = new DeprecatedElementsBindHandler();
        NoUnboundElementsBindHandler handler = new NoUnboundElementsBindHandler((BindHandler)new IgnoreTopLevelConverterNotFoundBindHandler((BindHandler)deprecatedHandler), (Function)new UnboundElementsSourceFilter());
        Binder configBinder = new Binder(ConfigurationPropertySources.from((Iterable)propertySources), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Iterable)propertySources), (ConversionService)conversionService, null, null, null);
        ArrayList<CasConfigurationPropertyBindingResult> validationResults = new ArrayList<CasConfigurationPropertyBindingResult>();
        beans.values().forEach(bean -> {
            try {
                ConfigurationPropertiesBean configBean = ConfigurationPropertiesBean.get((ApplicationContext)this.applicationContext, (Object)bean, (String)UUID.randomUUID().toString());
                Bindable target = configBean.asBindTarget();
                ConfigurationProperties annotation = configBean.getAnnotation();
                configBinder.bind(annotation.prefix(), target, (BindHandler)handler);
            }
            catch (BindException e) {
                Throwable patt0$temp = e.getCause();
                if (patt0$temp instanceof UnboundConfigurationPropertiesException) {
                    UnboundConfigurationPropertiesException ucpe = (UnboundConfigurationPropertiesException)patt0$temp;
                    validationResults.addAll(ucpe.getUnboundProperties().stream().map(prop -> new CasConfigurationPropertyBindingResult((ConfigurationProperty)prop, CasConfigurationPropertyBindingResult.BindingStatus.UNKNOWN)).toList());
                }
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        });
        deprecatedHandler.getDeprecatedProperties().stream().map(dcpe -> new CasConfigurationPropertyBindingResult((ConfigurationProperty)dcpe, CasConfigurationPropertyBindingResult.BindingStatus.DEPRECATED)).forEach(validationResults::add);
        return validationResults;
    }

    public void printReport(List<CasConfigurationPropertyBindingResult> results) {
        CasConfigurationMetadataRepository metadataRepository = (CasConfigurationMetadataRepository)this.applicationContext.getBean("casConfigurationMetadataRepository", CasConfigurationMetadataRepository.class);
        Object messages = results.stream().map(entry -> {
            String propertyName = entry.property().getName().toString();
            Object query = ((ConfigurationMetadataCatalogQuery.ConfigurationMetadataCatalogQueryBuilder)((ConfigurationMetadataCatalogQuery.ConfigurationMetadataCatalogQueryBuilder)ConfigurationMetadataCatalogQuery.builder().queryType(ConfigurationMetadataCatalogQuery.QueryTypes.CAS)).queryFilter(property -> Strings.CI.equals(propertyName, property.getName()) && property.isDeprecated())).build();
            CasConfigurationMetadataCatalog.CasPropertiesContainer container = CasConfigurationMetadataCatalog.query(query, metadataRepository);
            String status = entry.status().getLabel();
            if (container.hasProperties()) {
                return container.properties().stream().map(property -> {
                    Object propertyLine = "\t- %s Property: %s = %s%n".formatted(status, property.getName(), entry.property().getValue());
                    if (StringUtils.isNotBlank((CharSequence)property.getOwner())) {
                        propertyLine = (String)propertyLine + "\t  Owner: %s%n".formatted(property.getOwner());
                    }
                    if (StringUtils.isNotBlank((CharSequence)property.getShortDescription())) {
                        propertyLine = (String)propertyLine + "\t  Description: %s%n".formatted(property.getShortDescription());
                    }
                    if (StringUtils.isNotBlank((CharSequence)property.getDeprecationReplacement())) {
                        propertyLine = (String)propertyLine + "\t  Replacement: %s%n".formatted(property.getDeprecationReplacement());
                    }
                    if (StringUtils.isNotBlank((CharSequence)property.getDeprecationReason())) {
                        propertyLine = (String)propertyLine + "\t  Reason: %s%n".formatted(property.getDeprecationReason());
                    }
                    return propertyLine;
                }).toList();
            }
            return List.of("\t- %s Property: %s = %s".formatted(status, propertyName, entry.property().getValue()));
        }).flatMap(Collection::stream).collect(Collectors.joining("\n"));
        if (StringUtils.isNotBlank((CharSequence)messages)) {
            messages = "\nThe following settings are deprecated and scheduled to be removed in future releases of CAS. Please review the replacement settings where applicable and update your configuration accordingly.\n\n" + (String)messages;
            LOGGER.warn((String)messages);
        }
    }

    @Generated
    public CasConfigurationPropertiesValidator(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public void setConfigurationPropertyClasses(List<Class> configurationPropertyClasses) {
        this.configurationPropertyClasses = configurationPropertyClasses;
    }
}

