/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.DurationCapable;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.configuration.support.PropertyOwner;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.metadata.CasReferenceProperty;
import org.apereo.cas.metadata.ConfigurationMetadataCatalogQuery;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.util.ReflectionUtils;

public final class CasConfigurationMetadataCatalog {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    public static void export(File destination, Object data) {
        FunctionUtils.doUnchecked(__ -> {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true).configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper.writeValue(destination, data);
        }, (Object[])new Object[0]);
    }

    public static CasPropertiesContainer query(ConfigurationMetadataCatalogQuery query) {
        return CasConfigurationMetadataCatalog.query(query, new CasConfigurationMetadataRepository());
    }

    public static CasPropertiesContainer query(ConfigurationMetadataCatalogQuery query, CasConfigurationMetadataRepository repo) {
        List<Map.Entry> allProperties = repo.getRepository().getAllProperties().entrySet().stream().filter(entry -> {
            if (query.getQueryType() == ConfigurationMetadataCatalogQuery.QueryTypes.CAS) {
                return CasConfigurationMetadataRepository.isCasProperty((ConfigurationMetadataProperty)entry.getValue());
            }
            if (query.getQueryType() == ConfigurationMetadataCatalogQuery.QueryTypes.THIRD_PARTY) {
                return !CasConfigurationMetadataRepository.isCasProperty((ConfigurationMetadataProperty)entry.getValue());
            }
            return true;
        }).filter(entry -> query.getQueryFilter().test((ConfigurationMetadataProperty)entry.getValue())).toList();
        TreeSet properties = allProperties.stream().filter(entry -> CasConfigurationMetadataCatalog.doesPropertyBelongToModule((ConfigurationMetadataProperty)entry.getValue(), query)).map(Map.Entry::getValue).map(property -> CasConfigurationMetadataCatalog.collectReferenceProperty(property, repo.getRepository())).filter(Objects::nonNull).filter(property -> query.getRequiredPropertiesOnly() == null || query.getRequiredPropertiesOnly().equals(property.isRequired())).sorted(Comparator.comparing(CasReferenceProperty::getName)).collect(Collectors.toCollection(TreeSet::new));
        return new CasPropertiesContainer(properties);
    }

    private static boolean doesPropertyBelongToModule(ConfigurationMetadataProperty property, ConfigurationMetadataCatalogQuery query) {
        if (query.getModules().isEmpty()) {
            return true;
        }
        List valueHints = property.getHints().getValueHints();
        return valueHints.stream().filter(hint -> StringUtils.isNotBlank((CharSequence)hint.getDescription())).filter(hint -> hint.getDescription().equals(RequiresModule.class.getName())).anyMatch(hint -> {
            Map results = CasConfigurationMetadataCatalog.reasonJsonValueAsMap(hint.getValue().toString());
            String module = results.get("module").toString();
            return query.getModules().contains(module);
        });
    }

    private static Map reasonJsonValueAsMap(String value) {
        return (Map)FunctionUtils.doUnchecked(() -> (Map)MAPPER.readValue(value, Map.class));
    }

    private static CasReferenceProperty collectReferenceProperty(ConfigurationMetadataProperty property, ConfigurationMetadataRepository repository) {
        if (repository.getAllGroups().containsKey(property.getId())) {
            return null;
        }
        CasReferenceProperty.CasReferencePropertyBuilder<?, ?> builder = CasReferenceProperty.builder();
        builder.owner(CasConfigurationMetadataCatalog.determinePropertySourceType(property));
        property.getHints().getValueHints().forEach(Unchecked.consumer(hint -> {
            String description = hint.getDescription();
            if (StringUtils.isNotBlank((CharSequence)description)) {
                Map results;
                if (description.equals(RequiredProperty.class.getName())) {
                    builder.required(true);
                }
                if (description.equals(RequiresModule.class.getName())) {
                    results = (Map)MAPPER.readValue(hint.getValue().toString(), Map.class);
                    builder.module(results.get("module").toString());
                }
                if (description.equals(PropertyOwner.class.getName())) {
                    results = (Map)MAPPER.readValue(hint.getValue().toString(), Map.class);
                    builder.owner(results.get("owner").toString());
                }
                if (description.equals(DurationCapable.class.getName())) {
                    builder.duration(true);
                }
                if (description.equals(ExpressionLanguageCapable.class.getName())) {
                    builder.expressionLanguage(true);
                }
                if (description.equals(RegularExpressionCapable.class.getName())) {
                    builder.regexPattern(true);
                }
            }
        }));
        builder.type(property.getType());
        String description = StringUtils.defaultString((String)((String)StringUtils.defaultIfBlank((CharSequence)property.getDescription(), (CharSequence)property.getShortDescription())));
        builder.description(description);
        builder.shortDescription(property.getShortDescription());
        builder.name(property.getId());
        builder.defaultValue(ObjectUtils.getIfNull((Object)property.getDefaultValue(), (Object)""));
        if (property.isDeprecated()) {
            Deprecation deprecation = property.getDeprecation();
            builder.deprecationLevel(deprecation.getLevel().toString());
            if (deprecation.getShortReason() != null) {
                builder.deprecationReason(deprecation.getShortReason());
            }
            if (deprecation.getReplacement() != null) {
                builder.deprecationReplacement(deprecation.getReplacement());
            }
        }
        return builder.build();
    }

    private static String determinePropertySourceType(ConfigurationMetadataProperty property) {
        return (String)FunctionUtils.doUnchecked(() -> {
            Method method = ReflectionUtils.findMethod(property.getClass(), (String)"getSourceType");
            if (method == null) {
                return null;
            }
            method.setAccessible(true);
            return (String)method.invoke((Object)property, new Object[0]);
        });
    }

    @Generated
    private CasConfigurationMetadataCatalog() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record CasPropertiesContainer(Set<CasReferenceProperty> properties) {
        public boolean hasProperties() {
            return this.properties != null && !this.properties.isEmpty();
        }
    }
}

