/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBasicAuthClient
extends DirectClient {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectBasicAuthClient.class);
    private String realmName = "authentication required";

    public DirectBasicAuthClient() {
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new BasicAuthExtractor());
    }

    protected void checkCredentials(CallContext ctx, Credentials credentials) {
        WebContext webContext = ctx.webContext();
        if (credentials == null) {
            LOGGER.debug("Adding authenticate basic header");
            webContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        } else {
            LOGGER.debug("Remove authenticate header");
            webContext.setResponseHeader("WWW-Authenticate", null);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRealmName() {
        return this.realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectBasicAuthClient(super=" + super.toString() + ", realmName=" + this.realmName + ")";
    }
}

