/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.content;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.jackson.SyncopeJsonMapper;
import org.apache.syncope.core.persistence.api.content.ConfParamLoader;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class KeymasterConfParamLoader
implements ConfParamLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(KeymasterConfParamLoader.class);
    protected static final JsonMapper MAPPER = new SyncopeJsonMapper();
    protected final ConfParamOps confParamOps;
    protected final ConfigurableApplicationContext ctx;

    public KeymasterConfParamLoader(ConfParamOps confParamOps, ConfigurableApplicationContext ctx) {
        this.confParamOps = confParamOps;
        this.ctx = ctx;
    }

    public int getOrder() {
        return 450;
    }

    public void load(final String domain) {
        AuthContextUtils.runAsAdmin((String)domain, (Runnable)new Runnable(){
            final /* synthetic */ KeymasterConfParamLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @Transactional
            public void run() {
                boolean existingData;
                try {
                    existingData = !this.this$0.confParamOps.list(domain).isEmpty();
                }
                catch (Exception e) {
                    LOG.error("[{}] Could not access Keymaster", (Object)domain, (Object)e);
                    existingData = true;
                }
                if (existingData) {
                    LOG.info("[{}] Data found in Keymaster, leaving untouched", (Object)domain);
                } else {
                    LOG.info("[{}] Empty Keymaster found, loading default content", (Object)domain);
                    try (InputStream contentJSON = (InputStream)this.this$0.ctx.getBeanFactory().getBean(domain + "KeymasterConfParamsJSON", InputStream.class);){
                        JsonNode content = MAPPER.readTree(contentJSON);
                        for (Map.Entry param : content.properties()) {
                            Optional.ofNullable(MAPPER.treeToValue((TreeNode)param.getValue(), Object.class)).ifPresent(value -> this.this$0.confParamOps.set(domain, (String)param.getKey(), value));
                        }
                    }
                    catch (Exception e) {
                        LOG.error("[{}] While loading default Keymaster content", (Object)domain, (Object)e);
                    }
                }
            }
        });
    }
}

