/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.share.ErroneousAndValidPartitionData;
import kafka.server.share.FinalContext;
import kafka.server.share.ShareFetchContext;
import kafka.server.share.SharePartition;
import kafka.server.share.SharePartitionManager;
import kafka.server.share.ShareSessionContext;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidShareSessionEpochException;
import org.apache.kafka.common.errors.ShareSessionNotFoundException;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ShareFetchMetadata;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.group.share.NoOpShareStatePersister;
import org.apache.kafka.server.group.share.Persister;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.ShareSession;
import org.apache.kafka.server.share.ShareSessionCache;
import org.apache.kafka.server.share.ShareSessionKey;
import org.apache.kafka.server.util.timer.MockTimer;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Seq;

@Timeout(value=120L)
public class SharePartitionManagerTest {
    private static final int RECORD_LOCK_DURATION_MS = 30000;
    private static final int MAX_DELIVERY_COUNT = 5;
    private static final short MAX_IN_FLIGHT_MESSAGES = 200;
    private static final int PARTITION_MAX_BYTES = 40000;
    private static Timer mockTimer;
    private static final List<TopicIdPartition> EMPTY_PART_LIST;

    @BeforeEach
    public void setUp() {
        mockTimer = new SystemTimerReaper("sharePartitionManagerTestReaper", (Timer)new SystemTimer("sharePartitionManagerTestTimer"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        mockTimer.close();
    }

    @Test
    public void testNewContextReturnsFinalContext() {
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().build();
        ShareFetchMetadata newReqMetadata = new ShareFetchMetadata(Uuid.ZERO_UUID, -1);
        ShareFetchContext shareFetchContext = sharePartitionManager.newContext("grp", Collections.emptyMap(), Collections.emptyList(), newReqMetadata);
        Assertions.assertEquals(FinalContext.class, shareFetchContext.getClass());
        Uuid topicId = Uuid.randomUuid();
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData = Collections.singletonMap(new TopicIdPartition(topicId, new TopicPartition("foo", 0)), new ShareFetchRequest.SharePartitionData(topicId, 4000));
        Assertions.assertThrows(InvalidRequestException.class, () -> sharePartitionManager.newContext("grp", shareFetchData, Collections.emptyList(), new ShareFetchMetadata(Uuid.ZERO_UUID, -1)));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData2 = Collections.singletonMap(new TopicIdPartition(topicId, new TopicPartition("foo", 0)), new ShareFetchRequest.SharePartitionData(topicId, 0));
        shareFetchContext = sharePartitionManager.newContext("grp", shareFetchData2, Collections.emptyList(), newReqMetadata);
        Assertions.assertEquals(FinalContext.class, shareFetchContext.getClass());
    }

    @Test
    public void testNewContextReturnsFinalContextForEmptyTopicPartitionsAndFinalEpoch() {
        MockTime time = new MockTime();
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withTime((Time)time).build();
        String groupId = "grp";
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(Uuid.randomUuid(), -1));
        Assertions.assertEquals(FinalContext.class, context1.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewContext() {
        MockTime time = new MockTime();
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withTime((Time)time).build();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid tpId0 = Uuid.randomUuid();
        Uuid tpId1 = Uuid.randomUuid();
        topicNames.put(tpId0, "foo");
        topicNames.put(tpId1, "bar");
        TopicIdPartition tp0 = new TopicIdPartition(tpId0, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(tpId0, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(tpId1, new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition(tpId1, new TopicPartition("bar", 1));
        String groupId = "grp";
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData2 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData2.put(tp0, new ShareFetchRequest.SharePartitionData(tp0.topicId(), 100));
        reqData2.put(tp1, new ShareFetchRequest.SharePartitionData(tp1.topicId(), 100));
        ShareFetchMetadata reqMetadata2 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, reqMetadata2);
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context2).isSubsequent());
        ((ShareSessionContext)context2).shareFetchData().forEach((topicIdPartition, sharePartitionData) -> {
            Assertions.assertTrue((boolean)reqData2.containsKey(topicIdPartition));
            Assertions.assertEquals(reqData2.get(topicIdPartition), (Object)sharePartitionData);
        });
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(tp0, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        respData2.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals(respData2, (Object)resp2.responseData(topicNames));
        ShareSessionKey shareSessionKey2 = new ShareSessionKey(groupId, reqMetadata2.memberId());
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        Uuid memberId4 = Uuid.randomUuid();
        Assertions.assertThrows(ShareSessionNotFoundException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(memberId4, 1)));
        ShareFetchContext context5 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context5.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context5).isSubsequent());
        ShareSessionContext shareSessionContext5 = (ShareSessionContext)context5;
        ShareSession shareSession = shareSessionContext5.session();
        synchronized (shareSession) {
            shareSessionContext5.session().partitionMap().forEach(cachedSharePartition -> {
                TopicIdPartition topicIdPartition = new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()));
                ShareFetchRequest.SharePartitionData data = cachedSharePartition.reqData();
                Assertions.assertTrue((boolean)reqData2.containsKey(topicIdPartition));
                Assertions.assertEquals(reqData2.get(topicIdPartition), (Object)data);
            });
        }
        ShareFetchResponse resp5 = context5.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)0, (int)resp5.responseData(topicNames).size());
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        ShareFetchContext context7 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 2));
        ShareFetchResponse resp7 = context7.throttleResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        ShareFetchContext context8 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata2.memberId(), -1));
        Assertions.assertEquals(FinalContext.class, context8.getClass());
        Assertions.assertEquals((int)0, (int)cache.size());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData8.put(tp2, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        respData8.put(tp3, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        ShareFetchResponse resp8 = context8.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData8);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
    }

    @Test
    public void testShareSessionExpiration() {
        MockTime time = new MockTime();
        ShareSessionCache cache = new ShareSessionCache(2, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withTime((Time)time).build();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> session1req = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        session1req.put(foo0, new ShareFetchRequest.SharePartitionData(foo0.topicId(), 100));
        session1req.put(foo1, new ShareFetchRequest.SharePartitionData(foo1.topicId(), 100));
        String groupId = "grp";
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext session1context = sharePartitionManager.newContext(groupId, session1req, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(session1context.getClass(), ShareSessionContext.class);
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData1.put(foo0, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo0.partition()));
        respData1.put(foo1, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo1.partition()));
        ShareFetchResponse session1resp = session1context.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames).size());
        ShareSessionKey session1Key = new ShareSessionKey(groupId, reqMetadata1.memberId());
        Assertions.assertNotNull((Object)cache.get(session1Key));
        time.sleep(500L);
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> session2req = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        session2req.put(foo0, new ShareFetchRequest.SharePartitionData(foo0.topicId(), 100));
        session2req.put(foo1, new ShareFetchRequest.SharePartitionData(foo1.topicId(), 100));
        ShareFetchMetadata reqMetadata2 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext session2context = sharePartitionManager.newContext(groupId, session2req, EMPTY_PART_LIST, reqMetadata2);
        Assertions.assertEquals(session2context.getClass(), ShareSessionContext.class);
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(foo0, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo0.partition()));
        respData2.put(foo1, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo1.partition()));
        ShareFetchResponse session2resp = session2context.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames).size());
        ShareSessionKey session2Key = new ShareSessionKey(groupId, reqMetadata2.memberId());
        Assertions.assertNotNull((Object)cache.get(session1Key));
        Assertions.assertNotNull((Object)cache.get(session2Key));
        time.sleep(500L);
        ShareFetchContext session1context2 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata1.memberId(), 1));
        Assertions.assertEquals(session1context2.getClass(), ShareSessionContext.class);
        time.sleep(501L);
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> session3req = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        session3req.put(foo0, new ShareFetchRequest.SharePartitionData(foo0.topicId(), 100));
        session3req.put(foo1, new ShareFetchRequest.SharePartitionData(foo1.topicId(), 100));
        ShareFetchMetadata reqMetadata3 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext session3context = sharePartitionManager.newContext(groupId, session3req, EMPTY_PART_LIST, reqMetadata3);
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData3.put(foo0, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo0.partition()));
        respData3.put(foo1, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo1.partition()));
        ShareFetchResponse session3resp = session3context.updateAndGenerateResponseData(groupId, reqMetadata3.memberId(), respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames).size());
        ShareSessionKey session3Key = new ShareSessionKey(groupId, reqMetadata3.memberId());
        Assertions.assertNotNull((Object)cache.get(session1Key));
        Assertions.assertNull((Object)cache.get(session2Key), (String)"share session 2 should have been evicted by latest share session, as share session 1 was used more recently");
        Assertions.assertNotNull((Object)cache.get(session3Key));
    }

    @Test
    public void testSubsequentShareSession() {
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().build();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        topicNames.put(barId, "bar");
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData1 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData1.put(tp0, new ShareFetchRequest.SharePartitionData(tp0.topicId(), 100));
        reqData1.put(tp1, new ShareFetchRequest.SharePartitionData(tp1.topicId(), 100));
        String groupId = "grp";
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, reqData1, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(ShareSessionContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData1.put(tp0, new ShareFetchResponseData.PartitionData().setPartitionIndex(tp0.partition()));
        respData1.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(tp1.partition()));
        ShareFetchResponse resp1 = context1.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames).size());
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData2 = Collections.singletonMap(tp2, new ShareFetchRequest.SharePartitionData(tp2.topicId(), 100));
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(tp0);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, reqData2, removed2, new ShareFetchMetadata(reqMetadata1.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        HashSet<TopicIdPartition> expectedTopicIdPartitions2 = new HashSet<TopicIdPartition>();
        expectedTopicIdPartitions2.add(tp1);
        expectedTopicIdPartitions2.add(tp2);
        HashSet actualTopicIdPartitions2 = new HashSet();
        ShareSessionContext shareSessionContext = (ShareSessionContext)context2;
        shareSessionContext.session().partitionMap().forEach(cachedSharePartition -> {
            TopicIdPartition topicIdPartition = new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()));
            actualTopicIdPartitions2.add(topicIdPartition);
        });
        Assertions.assertEquals(expectedTopicIdPartitions2, actualTopicIdPartitions2);
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(tp1.partition()));
        respData2.put(tp2, new ShareFetchResponseData.PartitionData().setPartitionIndex(tp2.partition()));
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.data().responses().size());
        Assertions.assertEquals((Object)barId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)resp2.data().responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)resp2.data().responses().get(0)).partitions().size());
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)resp2.data().responses().get(0)).partitions().get(0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)resp2.responseData(topicNames).size());
    }

    @Test
    public void testZeroSizeShareSession() {
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData1 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData1.put(foo0, new ShareFetchRequest.SharePartitionData(foo0.topicId(), 100));
        reqData1.put(foo1, new ShareFetchRequest.SharePartitionData(foo1.topicId(), 100));
        String groupId = "grp";
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, reqData1, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(ShareSessionContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData1.put(foo0, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo0.partition()));
        respData1.put(foo1, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo1.partition()));
        ShareFetchResponse resp1 = context1.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames).size());
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(foo0);
        removed2.add(foo1);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), removed2, new ShareFetchMetadata(reqMetadata1.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData2);
        Assertions.assertTrue((boolean)resp2.responseData(topicNames).isEmpty());
        Assertions.assertEquals((int)1, (int)cache.size());
    }

    @Test
    public void testToForgetPartitions() {
        String groupId = "grp";
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        TopicIdPartition foo = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData1 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData1.put(foo, new ShareFetchRequest.SharePartitionData(foo.topicId(), 100));
        reqData1.put(bar, new ShareFetchRequest.SharePartitionData(bar.topicId(), 100));
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, reqData1, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(ShareSessionContext.class, context1.getClass());
        this.assertPartitionsPresent((ShareSessionContext)context1, Arrays.asList(foo, bar));
        this.mockUpdateAndGenerateResponseData(context1, groupId, reqMetadata1.memberId());
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), Collections.singletonList(foo), new ShareFetchMetadata(reqMetadata1.memberId(), 1));
        this.assertPartitionsPresent((ShareSessionContext)context2, Collections.singletonList(bar));
        this.mockUpdateAndGenerateResponseData(context2, groupId, reqMetadata1.memberId());
        ShareFetchContext context3 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), Collections.singletonList(bar), new ShareFetchMetadata(reqMetadata1.memberId(), 2));
        this.assertPartitionsPresent((ShareSessionContext)context3, Collections.emptyList());
    }

    @Test
    public void testShareSessionUpdateTopicIdsBrokerSide() {
        String groupId = "grp";
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        TopicIdPartition foo = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(barId, new TopicPartition("bar", 1));
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(fooId, "foo");
        topicNames.put(barId, "bar");
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData1 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData1.put(foo, new ShareFetchRequest.SharePartitionData(foo.topicId(), 100));
        reqData1.put(bar, new ShareFetchRequest.SharePartitionData(bar.topicId(), 100));
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, reqData1, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(ShareSessionContext.class, context1.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context1).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData1.put(bar, new ShareFetchResponseData.PartitionData().setPartitionIndex(bar.partition()));
        respData1.put(foo, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo.partition()).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        ShareFetchResponse resp1 = context1.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames).size());
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata1.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context2).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(foo, new ShareFetchResponseData.PartitionData().setPartitionIndex(foo.partition()).setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code()));
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((short)Errors.INCONSISTENT_TOPIC_ID.code(), (short)((ShareFetchResponseData.PartitionData)resp2.responseData(topicNames).get(foo)).errorCode());
    }

    @Test
    public void testGetErroneousAndValidTopicIdPartitions() {
        MockTime time = new MockTime();
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withTime((Time)time).build();
        Uuid tpId0 = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(tpId0, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(tpId0, new TopicPartition("foo", 1));
        TopicIdPartition tpNull1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(null, 0));
        TopicIdPartition tpNull2 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(null, 1));
        String groupId = "grp";
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData2 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData2.put(tp0, new ShareFetchRequest.SharePartitionData(tp0.topicId(), 100));
        reqData2.put(tp1, new ShareFetchRequest.SharePartitionData(tp1.topicId(), 100));
        reqData2.put(tpNull1, new ShareFetchRequest.SharePartitionData(tpNull1.topicId(), 100));
        ShareFetchMetadata reqMetadata2 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, reqMetadata2);
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context2).isSubsequent());
        this.assertErroneousAndValidTopicIdPartitions(context2.getErroneousAndValidTopicIdPartitions(), Collections.singletonList(tpNull1), Arrays.asList(tp0, tp1));
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(tp0, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        respData2.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        respData2.put(tpNull1, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        ShareSessionKey shareSessionKey2 = new ShareSessionKey(groupId, reqMetadata2.memberId());
        ShareFetchResponse resp2Throttle = context2.throttleResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2Throttle.error());
        Assertions.assertEquals((int)100, (int)resp2Throttle.throttleTimeMs());
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        Assertions.assertThrows(ShareSessionNotFoundException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(Uuid.randomUuid(), 1)));
        ShareFetchContext context5 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context5.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context5).isSubsequent());
        this.assertErroneousAndValidTopicIdPartitions(context5.getErroneousAndValidTopicIdPartitions(), Collections.singletonList(tpNull1), Arrays.asList(tp0, tp1));
        ShareFetchResponse resp5 = context5.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData7 = Collections.singletonMap(tpNull2, new ShareFetchRequest.SharePartitionData(tpNull2.topicId(), 100));
        ShareFetchContext context7 = sharePartitionManager.newContext(groupId, reqData7, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 2));
        ShareFetchResponse resp7 = context7.throttleResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        this.assertErroneousAndValidTopicIdPartitions(context7.getErroneousAndValidTopicIdPartitions(), Arrays.asList(tpNull1, tpNull2), Arrays.asList(tp0, tp1));
        ShareFetchContext context8 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata2.memberId(), -1));
        Assertions.assertEquals(FinalContext.class, context8.getClass());
        Assertions.assertEquals((int)0, (int)cache.size());
        this.assertErroneousAndValidTopicIdPartitions(context8.getErroneousAndValidTopicIdPartitions(), Collections.emptyList(), Collections.emptyList());
        ShareFetchResponse resp8 = context8.throttleResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        Assertions.assertEquals((int)100, (int)resp8.throttleTimeMs());
    }

    @Test
    public void testShareFetchContextResponseSize() {
        MockTime time = new MockTime();
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withTime((Time)time).build();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid tpId0 = Uuid.randomUuid();
        Uuid tpId1 = Uuid.randomUuid();
        topicNames.put(tpId0, "foo");
        topicNames.put(tpId1, "bar");
        TopicIdPartition tp0 = new TopicIdPartition(tpId0, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(tpId0, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(tpId1, new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition(tpId1, new TopicPartition("bar", 1));
        String groupId = "grp";
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData2 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData2.put(tp0, new ShareFetchRequest.SharePartitionData(tp0.topicId(), 100));
        reqData2.put(tp1, new ShareFetchRequest.SharePartitionData(tp1.topicId(), 100));
        ObjectSerializationCache objectSerializationCache = new ObjectSerializationCache();
        short version = ApiKeys.SHARE_FETCH.latestVersion();
        ShareFetchMetadata reqMetadata2 = new ShareFetchMetadata(Uuid.randomUuid(), 0);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, reqMetadata2);
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context2).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(tp0, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        respData2.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        int respSize2 = context2.responseSize(respData2, version);
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals(respData2, (Object)resp2.responseData(topicNames));
        Assertions.assertEquals((int)(4 + resp2.data().size(objectSerializationCache, version)), (int)respSize2);
        ShareSessionKey shareSessionKey2 = new ShareSessionKey(groupId, reqMetadata2.memberId());
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        Uuid memberId4 = Uuid.randomUuid();
        Assertions.assertThrows(ShareSessionNotFoundException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(memberId4, 1)));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData5 = Collections.singletonMap(tp2, new ShareFetchRequest.SharePartitionData(tp2.topicId(), 100));
        ShareFetchContext context5 = sharePartitionManager.newContext(groupId, reqData5, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context5.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context5).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData5 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData5.put(tp2, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        int respSize5 = context5.responseSize(respData5, version);
        ShareFetchResponse resp5 = context5.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData5);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)(4 + resp5.data().size(objectSerializationCache, version)), (int)respSize5);
        Assertions.assertThrows(InvalidShareSessionEpochException.class, () -> sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 5)));
        ShareFetchContext context7 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey2.memberId(), 2));
        int respSize7 = context7.responseSize(respData2, version);
        ShareFetchResponse resp7 = context7.throttleResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        Assertions.assertEquals((int)(4 + new ShareFetchResponseData().size(objectSerializationCache, version)), (int)respSize7);
        ShareFetchContext context8 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata2.memberId(), -1));
        Assertions.assertEquals(FinalContext.class, context8.getClass());
        Assertions.assertEquals((int)0, (int)cache.size());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData8.put(tp3, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        int respSize8 = context8.responseSize(respData8, version);
        ShareFetchResponse resp8 = context8.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData8);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        Assertions.assertEquals((int)(4 + resp8.data().size(objectSerializationCache, version)), (int)respSize8);
    }

    @Test
    public void testCachedTopicPartitionsWithNoTopicPartitions() {
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        List result = sharePartitionManager.cachedTopicIdPartitionsInShareSession("grp", Uuid.randomUuid());
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCachedTopicPartitionsForValidShareSessions() {
        ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        Uuid tpId0 = Uuid.randomUuid();
        Uuid tpId1 = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(tpId0, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(tpId0, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(tpId1, new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition(tpId1, new TopicPartition("bar", 1));
        String groupId = "grp";
        Uuid memberId1 = Uuid.randomUuid();
        Uuid memberId2 = Uuid.randomUuid();
        LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData1 = new LinkedHashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        reqData1.put(tp0, new ShareFetchRequest.SharePartitionData(tp0.topicId(), 100));
        reqData1.put(tp1, new ShareFetchRequest.SharePartitionData(tp1.topicId(), 100));
        ShareFetchMetadata reqMetadata1 = new ShareFetchMetadata(memberId1, 0);
        ShareFetchContext context1 = sharePartitionManager.newContext(groupId, reqData1, EMPTY_PART_LIST, reqMetadata1);
        Assertions.assertEquals(ShareSessionContext.class, context1.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context1).isSubsequent());
        ShareSessionKey shareSessionKey1 = new ShareSessionKey(groupId, reqMetadata1.memberId());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData1.put(tp0, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        respData1.put(tp1, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        ShareFetchResponse resp1 = context1.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertEquals(new HashSet<TopicIdPartition>(Arrays.asList(tp0, tp1)), new HashSet(sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId1)));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData2 = Collections.singletonMap(tp2, new ShareFetchRequest.SharePartitionData(tp2.topicId(), 100));
        ShareFetchMetadata reqMetadata2 = new ShareFetchMetadata(memberId2, 0);
        ShareFetchContext context2 = sharePartitionManager.newContext(groupId, reqData2, EMPTY_PART_LIST, reqMetadata2);
        Assertions.assertEquals(ShareSessionContext.class, context2.getClass());
        Assertions.assertFalse((boolean)((ShareSessionContext)context2).isSubsequent());
        ShareSessionKey shareSessionKey2 = new ShareSessionKey(groupId, reqMetadata2.memberId());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData2.put(tp2, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        ShareFetchResponse resp2 = context2.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals(Collections.singletonList(tp2), (Object)sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId2));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData3 = Collections.singletonMap(tp2, new ShareFetchRequest.SharePartitionData(tp2.topicId(), 100));
        ShareFetchContext context3 = sharePartitionManager.newContext(groupId, reqData3, EMPTY_PART_LIST, new ShareFetchMetadata(shareSessionKey1.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context3.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context3).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData3.put(tp2, new ShareFetchResponseData.PartitionData().setPartitionIndex(0));
        ShareFetchResponse resp3 = context3.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals(new HashSet<TopicIdPartition>(Arrays.asList(tp0, tp1, tp2)), new HashSet(sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId1)));
        Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> reqData4 = Collections.singletonMap(tp3, new ShareFetchRequest.SharePartitionData(tp3.topicId(), 100));
        ShareFetchContext context4 = sharePartitionManager.newContext(groupId, reqData4, Collections.singletonList(tp2), new ShareFetchMetadata(shareSessionKey2.memberId(), 1));
        Assertions.assertEquals(ShareSessionContext.class, context4.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context4).isSubsequent());
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        respData4.put(tp3, new ShareFetchResponseData.PartitionData().setPartitionIndex(1));
        ShareFetchResponse resp4 = context4.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals(Collections.singletonList(tp3), (Object)sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId2));
        ShareFetchContext context5 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), EMPTY_PART_LIST, new ShareFetchMetadata(reqMetadata1.memberId(), -1));
        Assertions.assertEquals(FinalContext.class, context5.getClass());
        LinkedHashMap respData5 = new LinkedHashMap();
        ShareFetchResponse resp5 = context5.updateAndGenerateResponseData(groupId, reqMetadata1.memberId(), respData5);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertTrue((boolean)sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId1).isEmpty());
        ShareFetchContext context6 = sharePartitionManager.newContext(groupId, Collections.emptyMap(), Collections.singletonList(tp3), new ShareFetchMetadata(shareSessionKey2.memberId(), 2));
        Assertions.assertEquals(ShareSessionContext.class, context6.getClass());
        Assertions.assertTrue((boolean)((ShareSessionContext)context6).isSubsequent());
        LinkedHashMap respData6 = new LinkedHashMap();
        ShareFetchResponse resp6 = context6.updateAndGenerateResponseData(groupId, reqMetadata2.memberId(), respData6);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp6.error());
        Assertions.assertEquals(Collections.emptyList(), (Object)sharePartitionManager.cachedTopicIdPartitionsInShareSession(groupId, memberId2));
    }

    @Test
    public void testSharePartitionKey() {
        SharePartitionManager.SharePartitionKey sharePartitionKey1 = new SharePartitionManager.SharePartitionKey("mock-group-1", new TopicIdPartition(new Uuid(0L, 1L), new TopicPartition("test", 0)));
        SharePartitionManager.SharePartitionKey sharePartitionKey2 = new SharePartitionManager.SharePartitionKey("mock-group-2", new TopicIdPartition(new Uuid(0L, 1L), new TopicPartition("test", 0)));
        SharePartitionManager.SharePartitionKey sharePartitionKey3 = new SharePartitionManager.SharePartitionKey("mock-group-1", new TopicIdPartition(new Uuid(1L, 1L), new TopicPartition("test-1", 0)));
        SharePartitionManager.SharePartitionKey sharePartitionKey4 = new SharePartitionManager.SharePartitionKey("mock-group-1", new TopicIdPartition(new Uuid(0L, 1L), new TopicPartition("test", 1)));
        SharePartitionManager.SharePartitionKey sharePartitionKey5 = new SharePartitionManager.SharePartitionKey("mock-group-1", new TopicIdPartition(new Uuid(0L, 0L), new TopicPartition("test-2", 0)));
        SharePartitionManager.SharePartitionKey sharePartitionKey1Copy = new SharePartitionManager.SharePartitionKey("mock-group-1", new TopicIdPartition(new Uuid(0L, 1L), new TopicPartition("test", 0)));
        Assertions.assertEquals((Object)sharePartitionKey1, (Object)sharePartitionKey1Copy);
        Assertions.assertNotEquals((Object)sharePartitionKey1, (Object)sharePartitionKey2);
        Assertions.assertNotEquals((Object)sharePartitionKey1, (Object)sharePartitionKey3);
        Assertions.assertNotEquals((Object)sharePartitionKey1, (Object)sharePartitionKey4);
        Assertions.assertNotEquals((Object)sharePartitionKey1, (Object)sharePartitionKey5);
        Assertions.assertNotEquals((Object)sharePartitionKey1, null);
    }

    @Test
    public void testMultipleSequentialShareFetches() {
        String groupId = "grp";
        Uuid memberId1 = Uuid.randomUuid();
        FetchParams fetchParams = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition(barId, new TopicPartition("bar", 1));
        TopicIdPartition tp4 = new TopicIdPartition(fooId, new TopicPartition("foo", 2));
        TopicIdPartition tp5 = new TopicIdPartition(barId, new TopicPartition("bar", 2));
        TopicIdPartition tp6 = new TopicIdPartition(fooId, new TopicPartition("foo", 3));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        partitionMaxBytes.put(tp2, 40000);
        partitionMaxBytes.put(tp3, 40000);
        partitionMaxBytes.put(tp4, 40000);
        partitionMaxBytes.put(tp5, 40000);
        partitionMaxBytes.put(tp6, 40000);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Time time = (Time)Mockito.mock(Time.class);
        Mockito.when((Object)time.hiResClockMs()).thenReturn((Object)0L).thenReturn((Object)100L);
        Metrics metrics = new Metrics();
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withReplicaManager(replicaManager).withTime(time).withMetrics(metrics).build();
        ((ReplicaManager)Mockito.doAnswer(invocation -> {
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).when((Object)replicaManager)).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        sharePartitionManager.fetchMessages(groupId, memberId1.toString(), fetchParams, Arrays.asList(tp0, tp1, tp2, tp3), partitionMaxBytes);
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        sharePartitionManager.fetchMessages(groupId, memberId1.toString(), fetchParams, Collections.singletonList(tp4), partitionMaxBytes);
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)2))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        sharePartitionManager.fetchMessages(groupId, memberId1.toString(), fetchParams, Arrays.asList(tp5, tp6), partitionMaxBytes);
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)3))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        HashMap<MetricName, Consumer> expectedMetrics = new HashMap<MetricName, Consumer>();
        expectedMetrics.put(metrics.metricName("partition-load-time-avg", "share-group-metrics"), val -> Assertions.assertEquals((int)val.intValue(), (int)14, (String)"partition-load-time-avg"));
        expectedMetrics.put(metrics.metricName("partition-load-time-max", "share-group-metrics"), val -> Assertions.assertEquals((Double)val, (double)100.0, (String)"partition-load-time-max"));
        expectedMetrics.forEach((metric, test) -> {
            Assertions.assertTrue((boolean)metrics.metrics().containsKey(metric));
            test.accept((Double)((KafkaMetric)metrics.metrics().get(metric)).metricValue());
        });
    }

    @Test
    public void testProcessFetchResponse() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp0), k -> new SharePartition(groupId, tp0, 200, 5, 30000, mockTimer, (Time)new MockTime(), NoOpShareStatePersister.getInstance()));
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp1), k -> new SharePartition(groupId, tp1, 200, 5, 30000, mockTimer, (Time)new MockTime(), NoOpShareStatePersister.getInstance()));
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        CompletableFuture future = new CompletableFuture();
        SharePartitionManager.ShareFetchPartitionData shareFetchPartitionData = new SharePartitionManager.ShareFetchPartitionData(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, memberId, Arrays.asList(tp0, tp1), future, partitionMaxBytes);
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        MemoryRecords records1 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        ArrayList<Tuple2> responseData = new ArrayList<Tuple2>();
        responseData.add(new Tuple2((Object)tp0, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        responseData.add(new Tuple2((Object)tp1, (Object)new FetchPartitionData(Errors.NONE, 0L, 100L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        CompletableFuture result = sharePartitionManager.processFetchResponse(shareFetchPartitionData, responseData);
        Assertions.assertTrue((boolean)result.isDone());
        Map resultData = (Map)result.join();
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    @Test
    public void testProcessFetchResponseWithEmptyRecords() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(topicId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(topicId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp0), k -> new SharePartition(groupId, tp0, 5, 200, 30000, mockTimer, (Time)new MockTime(), NoOpShareStatePersister.getInstance()));
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp1), k -> new SharePartition(groupId, tp1, 5, 200, 30000, mockTimer, (Time)new MockTime(), NoOpShareStatePersister.getInstance()));
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        CompletableFuture future = new CompletableFuture();
        SharePartitionManager.ShareFetchPartitionData shareFetchPartitionData = new SharePartitionManager.ShareFetchPartitionData(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, memberId, Arrays.asList(tp0, tp1), future, partitionMaxBytes);
        ArrayList<Tuple2> responseData = new ArrayList<Tuple2>();
        responseData.add(new Tuple2((Object)tp0, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        responseData.add(new Tuple2((Object)tp1, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        CompletableFuture result = sharePartitionManager.processFetchResponse(shareFetchPartitionData, responseData);
        Assertions.assertTrue((boolean)result.isDone());
        Map resultData = (Map)result.join();
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(Collections.emptyList(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(Collections.emptyList(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConcurrentShareFetches() throws InterruptedException {
        String groupId = "grp";
        Uuid memberId1 = Uuid.randomUuid();
        FetchParams fetchParams = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition(barId, new TopicPartition("bar", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        partitionMaxBytes.put(tp2, 40000);
        partitionMaxBytes.put(tp3, 40000);
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp0), arg_0 -> SharePartitionManagerTest.lambda$testMultipleConcurrentShareFetches$21(groupId, tp0, (Time)time, arg_0));
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp1), arg_0 -> SharePartitionManagerTest.lambda$testMultipleConcurrentShareFetches$22(groupId, tp1, (Time)time, arg_0));
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp2), arg_0 -> SharePartitionManagerTest.lambda$testMultipleConcurrentShareFetches$23(groupId, tp2, (Time)time, arg_0));
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp3), arg_0 -> SharePartitionManagerTest.lambda$testMultipleConcurrentShareFetches$24(groupId, tp3, (Time)time, arg_0));
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withTime((Time)time).withReplicaManager(replicaManager).build();
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp3 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)1L, (Object[])new Long[]{15L, 6L, 30L, 25L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{1L, 18L, 5L});
        Mockito.when((Object)sp2.nextFetchOffset()).thenReturn((Object)10L, (Object[])new Long[]{25L, 26L});
        Mockito.when((Object)sp3.nextFetchOffset()).thenReturn((Object)20L, (Object[])new Long[]{15L, 23L, 16L});
        ((ReplicaManager)Mockito.doAnswer(invocation -> {
            Assertions.assertEquals((long)1L, (long)sp0.nextFetchOffset());
            Assertions.assertEquals((long)4L, (long)sp1.nextFetchOffset());
            Assertions.assertEquals((long)10L, (long)sp2.nextFetchOffset());
            Assertions.assertEquals((long)20L, (long)sp3.nextFetchOffset());
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).doAnswer(invocation -> {
            Assertions.assertEquals((long)15L, (long)sp0.nextFetchOffset());
            Assertions.assertEquals((long)1L, (long)sp1.nextFetchOffset());
            Assertions.assertEquals((long)25L, (long)sp2.nextFetchOffset());
            Assertions.assertEquals((long)15L, (long)sp3.nextFetchOffset());
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).doAnswer(invocation -> {
            Assertions.assertEquals((long)6L, (long)sp0.nextFetchOffset());
            Assertions.assertEquals((long)18L, (long)sp1.nextFetchOffset());
            Assertions.assertEquals((long)26L, (long)sp2.nextFetchOffset());
            Assertions.assertEquals((long)23L, (long)sp3.nextFetchOffset());
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).doAnswer(invocation -> {
            Assertions.assertEquals((long)30L, (long)sp0.nextFetchOffset());
            Assertions.assertEquals((long)5L, (long)sp1.nextFetchOffset());
            Assertions.assertEquals((long)26L, (long)sp2.nextFetchOffset());
            Assertions.assertEquals((long)16L, (long)sp3.nextFetchOffset());
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).doAnswer(invocation -> {
            Assertions.assertEquals((long)25L, (long)sp0.nextFetchOffset());
            Assertions.assertEquals((long)5L, (long)sp1.nextFetchOffset());
            Assertions.assertEquals((long)26L, (long)sp2.nextFetchOffset());
            Assertions.assertEquals((long)16L, (long)sp3.nextFetchOffset());
            sharePartitionManager.releaseFetchQueueAndPartitionsLock(groupId, partitionMaxBytes.keySet());
            return null;
        }).when((Object)replicaManager)).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        int threadCount = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        try {
            for (int i = 0; i != threadCount; ++i) {
                executorService.submit(() -> sharePartitionManager.fetchMessages(groupId, memberId1.toString(), fetchParams, Arrays.asList(tp0, tp1, tp2, tp3), partitionMaxBytes));
                if (i % 10 != 0) continue;
                executorService.awaitTermination(50L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            if (!executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                executorService.shutdown();
            }
        }
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.atMost((int)100))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.atLeast((int)10))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
    }

    @Test
    public void testReplicaManagerFetchShouldNotProceed() {
        String groupId = "grp";
        Uuid memberId = Uuid.randomUuid();
        FetchParams fetchParams = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        Uuid fooId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)false);
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp0), sp0);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withReplicaManager(replicaManager).build();
        CompletableFuture future = sharePartitionManager.fetchMessages(groupId, memberId.toString(), fetchParams, Collections.singletonList(tp0), partitionMaxBytes);
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
        Map result = (Map)future.join();
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    public void testReplicaManagerFetchShouldProceed() {
        String groupId = "grp";
        Uuid memberId = Uuid.randomUuid();
        FetchParams fetchParams = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        Uuid fooId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.maybeAcquireFetchLock()).thenReturn((Object)true);
        Mockito.when((Object)sp0.canAcquireRecords()).thenReturn((Object)true);
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp0), sp0);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withReplicaManager(replicaManager).build();
        sharePartitionManager.fetchMessages(groupId, memberId.toString(), fetchParams, Collections.singletonList(tp0), partitionMaxBytes);
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
    }

    @Test
    public void testCloseSharePartitionManager() throws Exception {
        Timer timer = (Timer)Mockito.mock(SystemTimerReaper.class);
        Persister persister = (Persister)Mockito.mock(Persister.class);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withTimer(timer).withShareGroupPersister(persister).build();
        ((Timer)Mockito.verify((Object)timer, (VerificationMode)Mockito.times((int)0))).close();
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)0))).stop();
        sharePartitionManager.close();
        ((Timer)Mockito.verify((Object)timer, (VerificationMode)Mockito.times((int)1))).close();
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void testReleaseAcquiredRecordsSuccess() {
        String groupId = "grp";
        Uuid memberId = Uuid.randomUuid();
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp2 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 2));
        TopicIdPartition tp3 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("baz", 4));
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp1.releaseAcquiredRecords((String)ArgumentMatchers.eq((Object)memberId.toString()))).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        Mockito.when((Object)sp2.releaseAcquiredRecords((String)ArgumentMatchers.eq((Object)memberId.toString()))).thenReturn(CompletableFuture.completedFuture(Optional.of(new InvalidRecordStateException("Unable to release acquired records for the batch"))));
        ShareSessionCache cache = (ShareSessionCache)Mockito.mock(ShareSessionCache.class);
        ShareSession shareSession = (ShareSession)Mockito.mock(ShareSession.class);
        Mockito.when((Object)cache.get(new ShareSessionKey(groupId, memberId))).thenReturn((Object)shareSession);
        ImplicitLinkedHashCollection partitionMap = new ImplicitLinkedHashCollection(3);
        partitionMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition(tp1));
        partitionMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition(tp2));
        partitionMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition(tp3));
        Mockito.when((Object)shareSession.partitionMap()).thenReturn((Object)partitionMap);
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp1), sp1);
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp2), sp2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).withPartitionCacheMap(partitionCacheMap).build();
        CompletableFuture resultFuture = sharePartitionManager.releaseAcquiredRecords(groupId, memberId.toString());
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp1));
        Assertions.assertTrue((boolean)result.containsKey(tp2));
        Assertions.assertTrue((boolean)result.containsKey(tp3));
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp1)).errorCode());
        Assertions.assertEquals((int)2, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp2)).partitionIndex());
        Assertions.assertEquals((short)Errors.INVALID_RECORD_STATE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp2)).errorCode());
        Assertions.assertEquals((int)4, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp3)).partitionIndex());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp3)).errorCode());
    }

    @Test
    public void testReleaseAcquiredRecordsWithIncorrectGroupId() {
        String groupId = "grp";
        Uuid memberId = Uuid.randomUuid();
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        ShareSessionCache cache = (ShareSessionCache)Mockito.mock(ShareSessionCache.class);
        ShareSession shareSession = (ShareSession)Mockito.mock(ShareSession.class);
        Mockito.when((Object)cache.get(new ShareSessionKey(groupId, memberId))).thenReturn((Object)shareSession);
        ImplicitLinkedHashCollection partitionMap = new ImplicitLinkedHashCollection(3);
        partitionMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition(tp1));
        Mockito.when((Object)shareSession.partitionMap()).thenReturn((Object)partitionMap);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        CompletableFuture resultFuture = sharePartitionManager.releaseAcquiredRecords("grp-2", memberId.toString());
        Map result = (Map)resultFuture.join();
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testReleaseAcquiredRecordsWithIncorrectMemberId() {
        String groupId = "grp";
        Uuid memberId = Uuid.randomUuid();
        TopicIdPartition tp1 = new TopicIdPartition(memberId, new TopicPartition("foo", 0));
        ShareSessionCache cache = (ShareSessionCache)Mockito.mock(ShareSessionCache.class);
        ShareSession shareSession = (ShareSession)Mockito.mock(ShareSession.class);
        Mockito.when((Object)cache.get(new ShareSessionKey(groupId, Uuid.randomUuid()))).thenReturn((Object)shareSession);
        ImplicitLinkedHashCollection partitionMap = new ImplicitLinkedHashCollection(3);
        partitionMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition(tp1));
        Mockito.when((Object)shareSession.partitionMap()).thenReturn((Object)partitionMap);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withCache(cache).build();
        CompletableFuture resultFuture = sharePartitionManager.releaseAcquiredRecords(groupId, memberId.toString());
        Map result = (Map)resultFuture.join();
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testReleaseAcquiredRecordsWithEmptyTopicPartitions() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp2 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 2));
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp1.releaseAcquiredRecords((String)ArgumentMatchers.eq((Object)memberId))).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        Mockito.when((Object)sp2.releaseAcquiredRecords((String)ArgumentMatchers.eq((Object)memberId))).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp1), sp1);
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp2), sp2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        CompletableFuture resultFuture = sharePartitionManager.releaseAcquiredRecords(groupId, memberId);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    public void testAcknowledgeSinglePartition() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp2.acknowledge((String)ArgumentMatchers.eq((Object)memberId), (List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp), sp2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics = new HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>>();
        acknowledgeTopics.put(tp, Arrays.asList(new ShareAcknowledgementBatch(12L, 20L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(24L, 56L, Collections.singletonList((byte)1))));
        CompletableFuture resultFuture = sharePartitionManager.acknowledge(memberId, groupId, acknowledgeTopics);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp));
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).errorCode());
    }

    @Test
    public void testAcknowledgeMultiplePartition() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo1", 0));
        TopicIdPartition tp2 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo2", 0));
        TopicIdPartition tp3 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo3", 0));
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp3 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp1.acknowledge((String)ArgumentMatchers.eq((Object)memberId), (List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        Mockito.when((Object)sp2.acknowledge((String)ArgumentMatchers.eq((Object)memberId), (List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        Mockito.when((Object)sp3.acknowledge((String)ArgumentMatchers.eq((Object)memberId), (List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp1), sp1);
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp2), sp2);
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp3), sp3);
        Metrics metrics = new Metrics();
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withMetrics(metrics).build();
        HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics = new HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>>();
        acknowledgeTopics.put(tp1, Arrays.asList(new ShareAcknowledgementBatch(12L, 20L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(24L, 56L, Collections.singletonList((byte)1))));
        acknowledgeTopics.put(tp2, Arrays.asList(new ShareAcknowledgementBatch(15L, 26L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(34L, 56L, Collections.singletonList((byte)2))));
        acknowledgeTopics.put(tp3, Arrays.asList(new ShareAcknowledgementBatch(4L, 15L, Collections.singletonList((byte)3)), new ShareAcknowledgementBatch(16L, 21L, Collections.singletonList((byte)3))));
        CompletableFuture resultFuture = sharePartitionManager.acknowledge(memberId, groupId, acknowledgeTopics);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp1));
        Assertions.assertTrue((boolean)result.containsKey(tp2));
        Assertions.assertTrue((boolean)result.containsKey(tp3));
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp1)).errorCode());
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp2)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp2)).errorCode());
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp3)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp3)).errorCode());
        HashMap<MetricName, Consumer> expectedMetrics = new HashMap<MetricName, Consumer>();
        expectedMetrics.put(metrics.metricName("share-acknowledgement-count", "share-group-metrics"), val -> Assertions.assertEquals((Double)val, (double)1.0));
        expectedMetrics.put(metrics.metricName("share-acknowledgement-rate", "share-group-metrics"), val -> Assertions.assertTrue((val > 0.0 ? 1 : 0) != 0));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-count", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.ACCEPT.toString())), val -> Assertions.assertEquals((double)2.0, (Double)val));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-count", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.RELEASE.toString())), val -> Assertions.assertEquals((double)2.0, (Double)val));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-count", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.REJECT.toString())), val -> Assertions.assertEquals((double)2.0, (Double)val));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-rate", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.ACCEPT.toString())), val -> Assertions.assertTrue((val > 0.0 ? 1 : 0) != 0));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-rate", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.RELEASE.toString())), val -> Assertions.assertTrue((val > 0.0 ? 1 : 0) != 0));
        expectedMetrics.put(metrics.metricName("record-acknowledgement-rate", "share-group-metrics", Collections.singletonMap("ack-type", AcknowledgeType.REJECT.toString())), val -> Assertions.assertTrue((val > 0.0 ? 1 : 0) != 0));
        expectedMetrics.forEach((metric, test) -> {
            Assertions.assertTrue((boolean)metrics.metrics().containsKey(metric));
            test.accept((Double)((KafkaMetric)metrics.metrics().get(metric)).metricValue());
        });
    }

    @Test
    public void testAcknowledgeIncorrectGroupId() {
        String groupId = "grp";
        String groupId2 = "grp2";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp), sp2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics = new HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>>();
        acknowledgeTopics.put(tp, Arrays.asList(new ShareAcknowledgementBatch(12L, 20L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(24L, 56L, Collections.singletonList((byte)1))));
        CompletableFuture resultFuture = sharePartitionManager.acknowledge(memberId, groupId2, acknowledgeTopics);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp));
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).partitionIndex());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).errorCode());
    }

    @Test
    public void testAcknowledgeIncorrectMemberId() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp2.acknowledge((String)ArgumentMatchers.eq((Object)memberId), (List)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Optional.of(new InvalidRequestException("Member is not the owner of batch record"))));
        HashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp), sp2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).build();
        HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics = new HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>>();
        acknowledgeTopics.put(tp, Arrays.asList(new ShareAcknowledgementBatch(12L, 20L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(24L, 56L, Collections.singletonList((byte)1))));
        CompletableFuture resultFuture = sharePartitionManager.acknowledge(memberId, groupId, acknowledgeTopics);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp));
        Assertions.assertEquals((int)0, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).partitionIndex());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).errorCode());
    }

    @Test
    public void testAcknowledgeEmptyPartitionCacheMap() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo4", 3));
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().build();
        HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics = new HashMap<TopicIdPartition, List<ShareAcknowledgementBatch>>();
        acknowledgeTopics.put(tp, Arrays.asList(new ShareAcknowledgementBatch(78L, 90L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(94L, 99L, Collections.singletonList((byte)2))));
        CompletableFuture resultFuture = sharePartitionManager.acknowledge(memberId, groupId, acknowledgeTopics);
        Map result = (Map)resultFuture.join();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.containsKey(tp));
        Assertions.assertEquals((int)3, (int)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).partitionIndex());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((ShareAcknowledgeResponseData.PartitionData)result.get(tp)).errorCode());
    }

    @Test
    public void testProcessFetchResponseWithLsoMovementForTopicPartition() {
        String groupId = "grp";
        Uuid fooId = Uuid.randomUuid();
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp0), sp0);
        partitionCacheMap.put(new SharePartitionManager.SharePartitionKey(groupId, tp1), sp1);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withReplicaManager(replicaManager).build();
        SharePartitionManager sharePartitionManagersSpy = (SharePartitionManager)Mockito.spy((Object)sharePartitionManager);
        ((SharePartitionManager)Mockito.doReturn((Object)1L).when((Object)sharePartitionManagersSpy)).offsetForEarliestTimestamp((TopicIdPartition)ArgumentMatchers.any(TopicIdPartition.class));
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)0L, (Object[])new Long[]{5L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{4L});
        Mockito.when((Object)sp0.acquire((String)ArgumentMatchers.any(), (FetchPartitionData)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.emptyList()), (Object[])new CompletableFuture[]{CompletableFuture.completedFuture(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)))});
        Mockito.when((Object)sp1.acquire((String)ArgumentMatchers.any(), (FetchPartitionData)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1))), (Object[])new CompletableFuture[]{CompletableFuture.completedFuture(Collections.emptyList())});
        ((SharePartition)Mockito.doNothing().when((Object)sp1)).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((SharePartition)Mockito.doNothing().when((Object)sp0)).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        CompletableFuture future = new CompletableFuture();
        SharePartitionManager.ShareFetchPartitionData shareFetchPartitionData = new SharePartitionManager.ShareFetchPartitionData(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, Uuid.randomUuid().toString(), Arrays.asList(tp0, tp1), future, partitionMaxBytes);
        MemoryRecords records1 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        ArrayList<Tuple2> responseData1 = new ArrayList<Tuple2>();
        responseData1.add(new Tuple2((Object)tp0, (Object)new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        responseData1.add(new Tuple2((Object)tp1, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        CompletableFuture result1 = sharePartitionManagersSpy.processFetchResponse(shareFetchPartitionData, responseData1);
        Assertions.assertTrue((boolean)result1.isDone());
        Map resultData1 = (Map)result1.join();
        Assertions.assertEquals((int)2, (int)resultData1.size());
        Assertions.assertTrue((boolean)resultData1.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData1.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        MemoryRecords records2 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        ArrayList<Tuple2> responseData2 = new ArrayList<Tuple2>();
        responseData2.add(new Tuple2((Object)tp0, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        responseData2.add(new Tuple2((Object)tp1, (Object)new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        CompletableFuture result2 = sharePartitionManagersSpy.processFetchResponse(shareFetchPartitionData, responseData2);
        Assertions.assertTrue((boolean)result2.isDone());
        Map resultData2 = (Map)result2.join();
        Assertions.assertEquals((int)2, (int)resultData2.size());
        Assertions.assertTrue((boolean)resultData2.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData2.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }

    @Test
    public void testFetchQueueProcessingWhenFrontItemIsEmpty() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        FetchParams fetchParams = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        MockTime time = new MockTime();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartitionManager.ShareFetchPartitionData shareFetchPartitionData1 = new SharePartitionManager.ShareFetchPartitionData(fetchParams, groupId, memberId, Collections.emptyList(), new CompletableFuture(), partitionMaxBytes);
        SharePartitionManager.ShareFetchPartitionData shareFetchPartitionData2 = new SharePartitionManager.ShareFetchPartitionData(fetchParams, groupId, memberId, Collections.singletonList(tp0), new CompletableFuture(), partitionMaxBytes);
        ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new ConcurrentHashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        partitionCacheMap.computeIfAbsent(new SharePartitionManager.SharePartitionKey(groupId, tp0), arg_0 -> SharePartitionManagerTest.lambda$testFetchQueueProcessingWhenFrontItemIsEmpty$40(groupId, tp0, (Time)time, arg_0));
        ConcurrentLinkedQueue<SharePartitionManager.ShareFetchPartitionData> fetchQueue = new ConcurrentLinkedQueue<SharePartitionManager.ShareFetchPartitionData>();
        fetchQueue.add(shareFetchPartitionData1);
        fetchQueue.add(shareFetchPartitionData2);
        SharePartitionManager sharePartitionManager = SharePartitionManagerBuilder.builder().withPartitionCacheMap(partitionCacheMap).withReplicaManager(replicaManager).withTime((Time)time).withFetchQueue(fetchQueue).build();
        sharePartitionManager.maybeProcessFetchQueue();
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(ReplicaQuota.class), (Function1)ArgumentMatchers.any());
    }

    private ShareFetchResponseData.PartitionData noErrorShareFetchResponse() {
        return new ShareFetchResponseData.PartitionData().setPartitionIndex(0);
    }

    private ShareFetchResponseData.PartitionData errorShareFetchResponse(Short errorCode) {
        return new ShareFetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(errorCode.shortValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mockUpdateAndGenerateResponseData(ShareFetchContext context, String groupId, Uuid memberId) {
        LinkedHashMap data = new LinkedHashMap();
        if (context.getClass() == ShareSessionContext.class) {
            ShareSessionContext shareSessionContext = (ShareSessionContext)context;
            if (!shareSessionContext.isSubsequent()) {
                shareSessionContext.shareFetchData().forEach((topicIdPartition, sharePartitionData) -> data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorShareFetchResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorShareFetchResponse()));
            } else {
                ShareSession shareSession = shareSessionContext.session();
                synchronized (shareSession) {
                    shareSessionContext.session().partitionMap().forEach(cachedSharePartition -> {
                        TopicIdPartition topicIdPartition;
                        data.put(topicIdPartition, (topicIdPartition = new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()))).topic() == null ? this.errorShareFetchResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorShareFetchResponse());
                    });
                }
            }
        }
        context.updateAndGenerateResponseData(groupId, memberId, data);
    }

    private void assertPartitionsPresent(ShareSessionContext context, List<TopicIdPartition> partitions) {
        HashSet partitionsInContext = new HashSet();
        if (!context.isSubsequent()) {
            context.shareFetchData().forEach((topicIdPartition, sharePartitionData) -> partitionsInContext.add(topicIdPartition));
        } else {
            context.session().partitionMap().forEach(cachedSharePartition -> {
                TopicIdPartition topicIdPartition = new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()));
                partitionsInContext.add(topicIdPartition);
            });
        }
        HashSet<TopicIdPartition> partitionsSet = new HashSet<TopicIdPartition>(partitions);
        Assertions.assertEquals(partitionsSet, partitionsInContext);
    }

    private void assertErroneousAndValidTopicIdPartitions(ErroneousAndValidPartitionData erroneousAndValidPartitionData, List<TopicIdPartition> expectedErroneous, List<TopicIdPartition> expectedValid) {
        HashSet<TopicIdPartition> expectedErroneousSet = new HashSet<TopicIdPartition>(expectedErroneous);
        HashSet<TopicIdPartition> expectedValidSet = new HashSet<TopicIdPartition>(expectedValid);
        HashSet actualErroneousPartitions = new HashSet();
        HashSet actualValidPartitions = new HashSet();
        erroneousAndValidPartitionData.erroneous().forEach(topicIdPartitionPartitionDataTuple2 -> actualErroneousPartitions.add(topicIdPartitionPartitionDataTuple2._1));
        erroneousAndValidPartitionData.validTopicIdPartitions().forEach(topicIdPartitionPartitionDataTuple2 -> actualValidPartitions.add(topicIdPartitionPartitionDataTuple2._1));
        Assertions.assertEquals(expectedErroneousSet, actualErroneousPartitions);
        Assertions.assertEquals(expectedValidSet, actualValidPartitions);
    }

    private static /* synthetic */ SharePartition lambda$testFetchQueueProcessingWhenFrontItemIsEmpty$40(String groupId, TopicIdPartition tp0, Time time, SharePartitionManager.SharePartitionKey key) {
        return new SharePartition(groupId, tp0, 200, 5, 30000, mockTimer, time, NoOpShareStatePersister.getInstance());
    }

    private static /* synthetic */ SharePartition lambda$testMultipleConcurrentShareFetches$24(String groupId, TopicIdPartition tp3, Time time, SharePartitionManager.SharePartitionKey k) {
        return new SharePartition(groupId, tp3, 5, 200, 30000, mockTimer, time, NoOpShareStatePersister.getInstance());
    }

    private static /* synthetic */ SharePartition lambda$testMultipleConcurrentShareFetches$23(String groupId, TopicIdPartition tp2, Time time, SharePartitionManager.SharePartitionKey k) {
        return new SharePartition(groupId, tp2, 5, 200, 30000, mockTimer, time, NoOpShareStatePersister.getInstance());
    }

    private static /* synthetic */ SharePartition lambda$testMultipleConcurrentShareFetches$22(String groupId, TopicIdPartition tp1, Time time, SharePartitionManager.SharePartitionKey k) {
        return new SharePartition(groupId, tp1, 5, 200, 30000, mockTimer, time, NoOpShareStatePersister.getInstance());
    }

    private static /* synthetic */ SharePartition lambda$testMultipleConcurrentShareFetches$21(String groupId, TopicIdPartition tp0, Time time, SharePartitionManager.SharePartitionKey k) {
        return new SharePartition(groupId, tp0, 5, 200, 30000, mockTimer, time, NoOpShareStatePersister.getInstance());
    }

    static {
        EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());
    }

    private static class SharePartitionManagerBuilder {
        private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        private Time time = new MockTime();
        private ShareSessionCache cache = new ShareSessionCache(10, 1000L);
        private Map<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap = new HashMap<SharePartitionManager.SharePartitionKey, SharePartition>();
        private Persister persister = NoOpShareStatePersister.getInstance();
        private Timer timer = new MockTimer();
        private Metrics metrics = new Metrics();
        private ConcurrentLinkedQueue<SharePartitionManager.ShareFetchPartitionData> fetchQueue = new ConcurrentLinkedQueue();

        private SharePartitionManagerBuilder() {
        }

        private SharePartitionManagerBuilder withReplicaManager(ReplicaManager replicaManager) {
            this.replicaManager = replicaManager;
            return this;
        }

        private SharePartitionManagerBuilder withTime(Time time) {
            this.time = time;
            return this;
        }

        private SharePartitionManagerBuilder withCache(ShareSessionCache cache) {
            this.cache = cache;
            return this;
        }

        private SharePartitionManagerBuilder withPartitionCacheMap(Map<SharePartitionManager.SharePartitionKey, SharePartition> partitionCacheMap) {
            this.partitionCacheMap = partitionCacheMap;
            return this;
        }

        private SharePartitionManagerBuilder withShareGroupPersister(Persister persister) {
            this.persister = persister;
            return this;
        }

        private SharePartitionManagerBuilder withTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        private SharePartitionManagerBuilder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        private SharePartitionManagerBuilder withFetchQueue(ConcurrentLinkedQueue<SharePartitionManager.ShareFetchPartitionData> fetchQueue) {
            this.fetchQueue = fetchQueue;
            return this;
        }

        public static SharePartitionManagerBuilder builder() {
            return new SharePartitionManagerBuilder();
        }

        public SharePartitionManager build() {
            return new SharePartitionManager(this.replicaManager, this.time, this.cache, this.partitionCacheMap, this.fetchQueue, 30000, this.timer, 5, 200, this.persister, this.metrics);
        }
    }
}

