/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.network.Processor;
import kafka.server.ControllerServer;
import kafka.server.KafkaApis;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t\rf\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"I\u0011\r\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nQ\u0002\u0001\r\u0011!Q!\neC\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0003Y\u0007\"C7\u0001\u0001\u0004\u0005\t\u0015)\u0003Z\u0011\u001dq\u0007\u00011A\u0005\u0002=Dq!\u001f\u0001A\u0002\u0013\u0005!\u0010\u0003\u0004}\u0001\u0001\u0006K\u0001\u001d\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011%\t9\u0001\u0001a\u0001\n\u0003\tI\u0001C\u0004\u0002\u000e\u0001\u0001\u000b\u0015B@\t\u0017\u0005=\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0003\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0003C\u0006\u00022\u0001\u0001\r\u0011!Q!\n\u0005M\u0001\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0011!\t\t\u0005\u0001Q\u0001\n\u0005]\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005\u001d\u0003\u0002CA+\u0001\t\u0007I\u0011A$\t\u000f\u0005]\u0003\u0001)A\u0005\u0011\"I\u0011\u0011\f\u0001C\u0002\u0013\u0005\u00111\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002^!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002p!I\u0011Q\u0010\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002p!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014!9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005k\u0001A\u0011AAT\u0011\u001d\u00119\u0004\u0001C\u0001\u0003OCqA!\u000f\u0001\t\u0013\u0011Y\u0004C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!Q\u000e\u0001\u0005\u0002\t=\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'\u0013\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u0011q\u0007O\u0001\fS:$Xm\u001a:bi&|gNC\u0001:\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}B\u0014AB:feZ,'/\u0003\u0002B}\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005!\u0005CA#\u0001\u001b\u00051\u0014!\u00032s_.,'/\u001332+\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%aA%oi\u0006Q!M]8lKJLE-\r\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0014A\u00032s_.,'/\u001333A\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003M\u0003\"!\u0013+\n\u0005US%a\u0002\"p_2,\u0017M\\\u0001\u001aK:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007%\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'F\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0003vi&d'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:2?\u0012*\u0017\u000f\u0006\u0002dMB\u0011\u0011\nZ\u0005\u0003K*\u0013A!\u00168ji\"9q-CA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005i1m\u001c8gS\u001e\u0004&o\u001c9tc\u0001\nAbY8oM&<\u0007K]8qgJ\n\u0001cY8oM&<\u0007K]8qgJzF%Z9\u0015\u0005\rd\u0007bB4\r\u0003\u0003\u0005\r!W\u0001\u000eG>tg-[4Qe>\u00048O\r\u0011\u0002\u000f\r|gNZ5hgV\t\u0001\u000fE\u0002riZl\u0011A\u001d\u0006\u0003g*\u000b!bY8mY\u0016\u001cG/[8o\u0013\t)(OA\u0002TKF\u0004\"!P<\n\u0005at$aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u00111m\u001f\u0005\bO>\t\t\u00111\u0001q\u0003!\u0019wN\u001c4jON\u0004\u0013a\u00022s_.,'o]\u000b\u0002\u007fB!\u0011\u000f^A\u0001!\ri\u00141A\u0005\u0004\u0003\u000bq$aC&bM.\f'I]8lKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u00191-a\u0003\t\u000f\u001d\u0014\u0012\u0011!a\u0001\u007f\u0006A!M]8lKJ\u001c\b%A\u0003bI6Lg.\u0006\u0002\u0002\u0014A!\u0011QCA\u0014\u001b\t\t9B\u0003\u0003\u0002\u0010\u0005e!\u0002BA\u000e\u0003;\tqa\u00197jK:$8OC\u0002:\u0003?QA!!\t\u0002$\u00051\u0011\r]1dQ\u0016T!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005]!!B!e[&t\u0017!C1e[&tw\fJ3r)\r\u0019\u0017q\u0006\u0005\tOV\t\t\u00111\u0001\u0002\u0014\u00051\u0011\rZ7j]\u0002\naA]1oI>lWCAA\u001c!\u0011\tI$!\u0010\u000e\u0005\u0005m\"B\u0001/K\u0013\u0011\ty$a\u000f\u0003\rI\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\nQ\u0001^8qS\u000e,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014^\u0003\u0011a\u0017M\\4\n\t\u0005E\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u000f\u0003\u0019\u0019w.\\7p]&!\u0011qMA1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010W\u000647.Y!qSNdunZ4feV\u0011\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA\u0010\u0003\u0015awn\u001a\u001bk\u0013\u0011\tI(a\u001d\u0003\r1{wmZ3s\u0003AY\u0017MZ6b\u0003BL7\u000fT8hO\u0016\u0014\b%\u0001\foKR<xN]6Qe>\u001cWm]:pe2{wmZ3s\u0003]qW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b%A\u0003tKR,\u0006\u000fF\u0002d\u0003\u000bCq!a\"$\u0001\u0004\tI)\u0001\u0005uKN$\u0018J\u001c4p!\u0011\tY)!'\u000e\u0005\u00055%\u0002BAH\u0003#\u000b1!\u00199j\u0015\u0011\t\u0019*!&\u0002\u000f),\b/\u001b;fe*!\u0011qSA\u0012\u0003\u0015QWO\\5u\u0013\u0011\tY*!$\u0003\u0011Q+7\u000f^%oM>D3aIAP!\u0011\tY)!)\n\t\u0005\r\u0016Q\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003\rD3\u0001JAV!\u0011\tY)!,\n\t\u0005=\u0016Q\u0012\u0002\n\u0003\u001a$XM]#bG\"\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0005\u0003k\u000b9\fE\u0002rifCq!a\"&\u0001\u0004\tI)\u0001\u0007ti\u0006\u0014HO\u0011:pW\u0016\u00148\u000fF\u0002d\u0003{Cq!a0'\u0001\u0004\t),A\u0004dYV\u001cH/\u001a:\u0002AQ,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\r\u001a\u000b\u0004G\u0006\u0015\u0007bBAdO\u0001\u0007\u0011\u0011Z\u0001\u0007cV|'/^7\u0011\t\u0005-\u0017\u0011\u001c\b\u0005\u0003\u001b\f)\u000eE\u0002\u0002P*k!!!5\u000b\u0007\u0005M'(\u0001\u0004=e>|GOP\u0005\u0004\u0003/T\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0005m'bAAl\u0015\"\u001aq%a8\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GTA!!:\u0002\u0012\u00061\u0001/\u0019:b[NLA!!;\u0002d\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000f\u001d\ni/!?\u0002|B!\u0011q^A{\u001b\t\t\tP\u0003\u0003\u0002t\u0006\r\u0018\u0001\u00039s_ZLG-\u001a:\n\t\u0005]\u0018\u0011\u001f\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005u(\u0011A\u0011\u0003\u0003\u007f\f!A_6\"\u0005\t\r\u0011!B6sC\u001a$\u0018!\t;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$GcA2\u0003\n!9\u0011q\u0019\u0015A\u0002\u0005%\u0007f\u0001\u0015\u0002`\":\u0001&!<\u0002z\n=A\u0006BA\u007f\u0005\u0003\tq\u0006^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016$2a\u0019B\u000b\u0011\u001d\t9-\u000ba\u0001\u0003\u0013D3!KApQ\u001dI\u0013Q^A}\u00057aC!!@\u0003\u0002\u0005\u0001D/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016$2a\u0019B\u0011\u0011\u001d\t9M\u000ba\u0001\u0003\u0013D3AKApQ\u001dQ\u0013Q^A}\u0005OaC!!@\u0003\u0002\u0005iC/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u0013:4\u0018\r\\5e)>\u0004\u0018nY(wKJ\u0014\u0018\u000eZ3\u0015\u0007\r\u0014i\u0003C\u0004\u0002H.\u0002\r!!3)\u0007-\ny\u000eK\u0004,\u0003[\fIPa\r-\t\u0005u(\u0011A\u0001#m\u0016\u0014\u0018NZ=V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0002GY,'/\u001b4z+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\u0006Aq-\u001a;HCV<W\r\u0006\u0003\u0003>\tU\u0003\u0003\u0002B \u0005#j!A!\u0011\u000b\t\t\r#QI\u0001\u0005G>\u0014XM\u0003\u0003\u0003H\t%\u0013aB7fiJL7m\u001d\u0006\u0005\u0005\u0017\u0012i%\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005\u001f\n1aY8n\u0013\u0011\u0011\u0019F!\u0011\u0003\u000b5+G/\u001a:\t\u000f\t]c\u00061\u0001\u0002J\u0006QQ.\u001a;sS\u000et\u0015-\\3\u0002\u001dMDW\u000f\u001e3po:\u0014%o\\6feR\u00191M!\u0018\t\u000f\t}s\u00061\u0001\u0002\u0002\u00051!M]8lKJ\f!cY8ogVlW-\u00117m\u001b\u0016\u001c8/Y4fgR1!Q\rB4\u0005S\u0002B!\u001d;\u0002J\"9\u00111\t\u0019A\u0002\u0005%\u0007B\u0002B6a\u0001\u0007\u0001*A\u0006ok6lUm]:bO\u0016\u001c\u0018!\u000f;fgR$v\u000e]5d+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3XSRD\u0017\t\u001c;feR{\u0007/[2D_:4\u0017nZ:\u0015\u0007\r\u0014\t\bC\u0004\u0002HF\u0002\r!!3)\u0007E\ny\u000eK\u00042\u0003[\fIPa\u001e-\t\u0005u(\u0011A\u0001\u0012C2$XM\u001d+pa&\u001c7i\u001c8gS\u001e\u001cH\u0003\u0003B?\u0005\u0007\u00139I!#\u0011\t\u0005U!qP\u0005\u0005\u0005\u0003\u000b9B\u0001\nBYR,'oQ8oM&<7OU3tk2$\bb\u0002BCe\u0001\u0007\u00111C\u0001\fC\u0012l\u0017N\\\"mS\u0016tG\u000fC\u0004\u0002DI\u0002\r!!3\t\r\t-%\u00071\u0001Z\u00031!x\u000e]5d\u0007>tg-[4t\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0003\u0003'\t1e^1ji\u001a{'OT8MK\u0006$WM]!oI&\u001b(\u000fS1t\u001f2$G*Z1eKJLE\rF\u0003d\u0005+\u0013y\nC\u0004\u0003\u0018R\u0002\rA!'\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\ri$1T\u0005\u0004\u0005;s$!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0003\u0004\u0003\"R\u0002\r\u0001S\u0001\tY\u0016\fG-\u001a:JI\u0002")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1;
    private Properties configProps2;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaBroker> brokers = (Seq)Seq$.MODULE$.empty();
    private Admin admin;
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown()));
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)broker -> {
            CoreUtils$.MODULE$.delete(broker.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        this.admin().close();
        super.tearDown();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties properties = new Properties();
        if (((Method)testInfo.getTestMethod().get()).getName().contains("testUncleanLeaderElectionEnabled")) {
            properties.setProperty("unclean.leader.election.enable", "true");
        }
        properties.setProperty("unclean.leader.election.interval.ms", "10");
        return new .colon.colon((Object)properties, (List)Nil$.MODULE$);
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
        Properties adminConfigs = new Properties();
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), adminConfigs));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUncleanLeaderElectionEnabled(String quorum) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUncleanLeaderElectionDisabled(String quorum) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUncleanLeaderElectionEnabledByTopicOverride(String quorum) {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUncleanLeaderElectionDisabledByTopicOverride(String quorum) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUncleanLeaderElectionInvalidTopicOverride(String quorum) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Admin x$1 = this.admin();
            String x$2 = this.topic();
            Seq<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
            int x$7 = 1;
            int x$8 = 1;
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        });
        Assertions.assertEquals(InvalidConfigurationException.class, e.getCause().getClass());
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(leaderId, x$4)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$7(followerId, x$5))).get()).startup();
        Seq<KafkaBroker> x$1 = this.brokers();
        TopicPartition x$2 = this.topicPartition();
        Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$52 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$1, x$2, (Option<Object>)x$52, (Option<Object>)x$3, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(leaderId, x$6)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$7(followerId, x$7))).get();
        followerServer.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerServer.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$1 = this.brokers();
            String x$2 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$1, x$2, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, x$8))).get()).startup();
        Seq<KafkaBroker> x$72 = this.brokers();
        TopicPartition x$82 = this.topicPartition();
        Some x$92 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        None$ x$10 = None$.MODULE$;
        long x$11 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$72, x$82, (Option<Object>)x$10, (Option<Object>)x$92, x$11);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Inconsistent metadata after first server startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(leaderId, x$9)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        Seq<KafkaBroker> x$12 = this.brokers();
        TopicPartition x$13 = this.topicPartition();
        Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$15 = None$.MODULE$;
        long x$16 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$12, x$13, (Option<Object>)x$15, (Option<Object>)x$14, x$16);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private Meter getGauge(String metricName) {
        return (Meter)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$getGauge$1(metricName, x0$1))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString());
        }))._2();
    }

    private void shutdownBroker(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = "earliest";
        boolean x$6 = false;
        int x$7 = 500;
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$102 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        try (Consumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$5, false, x$6, x$7, x$8, (Option<File>)x$9, (Option<Properties>)x$102, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, 15000L).map((Function1 & Serializable)x$10 -> (String)x$10.value());
        }
        return seq;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs(String quorum) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        try (Admin adminClient = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$9 = this.brokers();
            TopicPartition x$10 = this.topicPartition();
            Some x$112 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$13 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$9, x$10, (Option<Object>)x$13, (Option<Object>)x$112, 10000L);
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "false");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$14 = this.brokers();
            TopicPartition x$15 = this.topicPartition();
            Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$18 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$14, x$15, (Option<Object>)x$18, (Option<Object>)x$16, 10000L);
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(leaderId, x$11)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerBroker = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(followerId, x$12))).get();
        followerBroker.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerBroker.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$19 = this.brokers();
            String x$20 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$19, x$20, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        try (Admin adminClient2 = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient2, this.topic(), newProps).all().get();
        }
        Seq<KafkaBroker> x$25 = this.brokers();
        TopicPartition x$26 = this.topicPartition();
        Some x$27 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$29 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$25, x$26, (Option<Object>)x$29, (Option<Object>)x$27, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new ConfigEntry(k, v);
            }
            throw new MatchError(null);
        })).toList()).asJava();
        return adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(configEntries).asScala().map((Function1 & Serializable)e -> new AlterConfigOp(e, AlterConfigOp.OpType.SET))).toSeq()).asJavaCollection())}))).asJava());
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForNoLeaderAndIsrHasOldLeaderId(MetadataCache metadataCache, int leaderId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(this, metadataCache, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker broker = $this.createBroker(config, $this.createBroker$default$2(), $this.createBroker$default$3(), $this.createBroker$default$4());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((IterableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$))));
        $this.brokers_$eq((Seq<KafkaBroker>)((Seq)$this.brokers().$plus$plus((IterableOnce)new .colon.colon((Object)broker, (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$5(int leaderId$1, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$7(int followerId$1, KafkaBroker x$5) {
        return x$5.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$5(int leaderId$2, KafkaBroker x$6) {
        return x$6.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$7(int followerId$2, KafkaBroker x$7) {
        return x$7.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaBroker x$8) {
        return x$8.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(UncleanLeaderElectionTest $this, KafkaBroker followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$11() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(int leaderId$2, KafkaBroker x$9) {
        return x$9.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getName().endsWith(metricName$1);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(int followerId$3, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(int leaderId$3, KafkaBroker x$11) {
        return x$11.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(int followerId$3, KafkaBroker x$12) {
        return x$12.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(UncleanLeaderElectionTest $this, MetadataCache metadataCache$1, int leaderId$4) {
        return metadataCache$1.getPartitionInfo($this.topic(), $this.partitionId()).isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)metadataCache$1.getPartitionInfo($this.topic(), $this.partitionId()).get()).leader() == -1 && ((Object)Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{leaderId$4}))).equals(((UpdateMetadataRequestData.UpdateMetadataPartitionState)metadataCache$1.getPartitionInfo($this.topic(), $this.partitionId()).get()).isr());
    }

    public static final /* synthetic */ String $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(UncleanLeaderElectionTest $this) {
        return new StringBuilder(81).append("Timed out waiting for broker metadata cache updates the info for topic partition:").append($this.topicPartition()).toString();
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

