/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.control.RequestControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationHandler
extends AbstractFreezable
implements AuthenticationHandler,
ConnectionFactoryManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionFactory factory;
    private RequestControl[] authenticationControls;

    @Override
    public void freeze() {
        super.freeze();
        AbstractAuthenticationHandler.freeze(this.factory);
    }

    @Override
    public final ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public final void setConnectionFactory(ConnectionFactory cf) {
        this.assertMutable();
        this.factory = cf;
    }

    public final RequestControl[] getAuthenticationControls() {
        return LdapUtils.copyArray(this.authenticationControls);
    }

    public final void setAuthenticationControls(RequestControl ... cntrls) {
        this.assertMutable();
        this.authenticationControls = LdapUtils.copyArray(cntrls);
    }

    @Override
    public AuthenticationHandlerResponse authenticate(AuthenticationCriteria ac) throws LdapException {
        AuthenticationHandlerResponse response;
        this.logger.trace("authenticate criteria={}", (Object)ac);
        Connection conn = this.factory.getConnection();
        boolean closeConn = false;
        try {
            conn.open();
            response = this.authenticateInternal(conn, ac);
        }
        catch (Exception e) {
            closeConn = true;
            throw e;
        }
        finally {
            if (closeConn) {
                conn.close();
            }
        }
        this.logger.debug("Authenticate response={} for criteria={}", (Object)response, (Object)ac);
        return response;
    }

    protected abstract AuthenticationHandlerResponse authenticateInternal(Connection var1, AuthenticationCriteria var2) throws LdapException;

    protected RequestControl[] processRequestControls(AuthenticationCriteria criteria) {
        RequestControl[] ctls = criteria.getAuthenticationRequest().getControls() != null ? (this.authenticationControls != null ? LdapUtils.concatArrays(criteria.getAuthenticationRequest().getControls(), new RequestControl[][]{this.authenticationControls}) : criteria.getAuthenticationRequest().getControls()) : this.authenticationControls;
        return ctls;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::factory=" + String.valueOf(this.factory) + ", controls=" + Arrays.toString(this.authenticationControls);
    }
}

