/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.tirasa.connid.bundles.ldup.LdUpConstants;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.modify.LdUpCreateOp;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObjectReference;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.ldaptive.AttributeModification;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.User;
import org.ldaptive.extended.ExtendedOperation;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.PasswordModifyRequest;
import org.ldaptive.handler.ResultPredicate;

abstract class AbstractLdUpModifyOp {
    protected final LdUpUtils ldUpUtils;

    protected static void process(Set<String> groupMembers, List<Object> values) {
        CollectionUtil.nullAsEmpty(values).stream().filter(Objects::nonNull).map(ConnectorObjectReference.class::cast).forEach(member -> Optional.ofNullable(member.getValue().getAttributeByName(Name.NAME)).filter(dns -> !CollectionUtil.isEmpty((Collection)dns.getValue())).ifPresent(dn -> groupMembers.add(dn.getValue().get(0).toString())));
    }

    protected static void process(LdapAttribute ldapAttr, List<Object> values) {
        values.stream().filter(Objects::nonNull).forEach(value -> {
            if (value instanceof byte[]) {
                ldapAttr.addBinaryValues(List.of((byte[])value));
            } else {
                ldapAttr.addStringValues(List.of(value.toString()));
            }
        });
    }

    protected AbstractLdUpModifyOp(LdUpUtils ldUpUtils) {
        this.ldUpUtils = ldUpUtils;
    }

    protected String findDn(ObjectClass objectClass, Uid uid) {
        String idAttr = this.ldUpUtils.getIdAttribute(objectClass);
        String dn = null;
        if (LdUpUtils.isDNAttribute(idAttr)) {
            dn = uid.getUidValue();
        } else {
            try {
                SearchDnResolver dnResolver = SearchDnResolver.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory()).dn(this.ldUpUtils.getConfiguration().getBaseDn()).subtreeSearch(true).filter("(" + idAttr + "={user})").build();
                dn = dnResolver.resolve(new User(uid.getUidValue()));
            }
            catch (LdapException e) {
                throw new ConnectorException("While resolving dn for " + uid.getUidValue(), (Throwable)e);
            }
        }
        if (dn == null) {
            throw new UnknownUidException(uid, objectClass);
        }
        try {
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((SearchRequest)SearchRequest.builder().dn(dn).scope(SearchScope.OBJECT).filter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass)).returnAttributes(ReturnAttributes.NONE.value()).build());
            if (response.getEntries().isEmpty()) {
                throw new ConnectorException("No entry found for " + dn + " and objectClass" + this.ldUpUtils.ldapObjectClass(objectClass));
            }
        }
        catch (LdapException e) {
            throw new ConnectorException("While reading " + dn, (Throwable)e);
        }
        return dn;
    }

    protected Uid uid(ObjectClass objectClass, String dn) {
        String idAttr = this.ldUpUtils.getIdAttribute(objectClass);
        if (LdUpUtils.isDNAttribute(idAttr)) {
            return new Uid(dn);
        }
        try {
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((SearchRequest)SearchRequest.builder().dn(dn).scope(SearchScope.OBJECT).filter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass)).returnAttributes(new String[]{idAttr}).build());
            if (response.getEntries().isEmpty()) {
                throw new ConnectorException("No entry found for " + dn + " and objectClass" + this.ldUpUtils.ldapObjectClass(objectClass));
            }
            return new Uid(response.getEntry().getAttribute(idAttr).getStringValue());
        }
        catch (LdapException e) {
            throw new ConnectorException("While reading " + dn, (Throwable)e);
        }
    }

    protected Set<String> findGroups(String dn) {
        HashSet<String> groups = new HashSet<String>();
        try {
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((SearchRequest)SearchRequest.builder().dn(this.ldUpUtils.getConfiguration().getBaseDn()).scope(SearchScope.SUBTREE).filter("(&(objectClass=" + this.ldUpUtils.getConfiguration().getGroupObjectClass() + ")(" + this.ldUpUtils.getConfiguration().getGroupMemberAttribute() + "=" + dn + "))").returnAttributes(ReturnAttributes.NONE.value()).build());
            groups.addAll(response.getEntryDns());
        }
        catch (LdapException e) {
            throw new ConnectorException("While searching for " + dn + " group memberships", (Throwable)e);
        }
        return groups;
    }

    protected void groupMod(String dn, Set<String> groups, AttributeModification.Type modType) {
        for (String group : groups) {
            try {
                ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(group).modifications(new AttributeModification[]{new AttributeModification(modType, new LdapAttribute(this.ldUpUtils.getConfiguration().getGroupMemberAttribute(), new String[]{dn}))}).build());
            }
            catch (LdapException e) {
                throw new ConnectorException("While performing " + modType + " for " + dn + " on " + group, (Throwable)e);
            }
        }
    }

    protected ProcessResult process(ObjectClass objectClass, Set<Attribute> attributes) {
        ProcessResult result = new ProcessResult();
        HashSet groupMembers = new HashSet();
        attributes.forEach(attr -> {
            if (!attr.is(Name.NAME)) {
                if ("ldapGroups".equals(attr.getName())) {
                    if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                        CollectionUtil.nullAsEmpty((List)attr.getValue()).stream().filter(Objects::nonNull).forEach(dn -> result.groups.add(dn.toString()));
                    } else {
                        LdUpCreateOp.LOG.warn("Skipping {0} because legacy compatibility mode is not set", new Object[]{attr.getName()});
                    }
                } else if (PredefinedAttributes.GROUPS_NAME.equals(attr.getName())) {
                    if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                        LdUpCreateOp.LOG.warn("Skipping {0} because legacy compatibility mode is set", new Object[]{attr.getName()});
                    } else {
                        AbstractLdUpModifyOp.process(result.groups, (List<Object>)attr.getValue());
                    }
                } else if (this.ldUpUtils.getConfiguration().getGroupMemberAttribute().equals(attr.getName())) {
                    if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                        CollectionUtil.nullAsEmpty((List)attr.getValue()).stream().filter(Objects::nonNull).forEach(dn -> groupMembers.add(dn.toString()));
                    } else {
                        LdUpCreateOp.LOG.warn("Skipping {0} because legacy compatibility mode is not set", new Object[]{attr.getName()});
                    }
                } else if (LdUpConstants.MEMBERS_ATTR_NAME.equals(attr.getName())) {
                    if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                        LdUpCreateOp.LOG.warn("Skipping {0} because legacy compatibility mode is set", new Object[]{attr.getName()});
                    } else {
                        AbstractLdUpModifyOp.process(groupMembers, (List<Object>)attr.getValue());
                    }
                } else if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    if (!CollectionUtil.isEmpty((Collection)attr.getValue())) {
                        result.passwordValue.set(SecurityUtil.decrypt((GuardedString)((GuardedString)attr.getValue().get(0))));
                    }
                } else {
                    this.ldUpUtils.getLdapAttribute(objectClass, attr.getName()).ifPresent(ldapName -> {
                        LdapAttribute ldapAttr = new LdapAttribute(ldapName);
                        result.ldapAttrs.add(ldapAttr);
                        AbstractLdUpModifyOp.process(ldapAttr, (List<Object>)CollectionUtil.nullAsEmpty((List)attr.getValue()));
                    });
                }
            }
        });
        if (this.ldUpUtils.isGroup(objectClass) && !groupMembers.isEmpty()) {
            LdapAttribute members = new LdapAttribute(this.ldUpUtils.getConfiguration().getGroupMemberAttribute());
            members.addStringValues(groupMembers);
            result.ldapAttrs.add(members);
        }
        return result;
    }

    protected void setPassword(String dn, AtomicReference<String> passwordValue) {
        if (passwordValue.get() != null) {
            try {
                ((ExtendedOperation)((ExtendedOperation.Builder)((ExtendedOperation.Builder)ExtendedOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ExtendedRequest)new PasswordModifyRequest(dn, null, passwordValue.get()));
            }
            catch (LdapException e) {
                throw new ConnectorException("Set password error", (Throwable)e);
            }
        }
    }

    protected static class ProcessResult {
        protected final List<LdapAttribute> ldapAttrs = new ArrayList<LdapAttribute>();
        protected final AtomicReference<String> passwordValue = new AtomicReference();
        protected final Set<String> groups = new HashSet<String>();

        protected ProcessResult() {
        }
    }
}

