/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenUtils;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;

public class OAuth20DefaultDeviceUserCodeFactory
implements OAuth20DeviceUserCodeFactory {
    protected final UniqueTicketIdGenerator ticketIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder;
    protected final int userCodeLength;
    protected final ServicesManager servicesManager;

    public OAuth20DeviceUserCode createDeviceUserCode(String id, Service service) {
        String userCode = (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)this.normalizeUserCode(RandomUtils.randomAlphanumeric((int)this.userCodeLength)));
        ExpirationPolicy expirationPolicyToUse = OAuth20DeviceTokenUtils.determineExpirationPolicyForService(this.servicesManager, this.expirationPolicyBuilder, service);
        OAuth20DefaultDeviceUserCode duc = new OAuth20DefaultDeviceUserCode(this.normalizeUserCode(userCode), service, expirationPolicyToUse);
        FunctionUtils.doIfNotNull((Object)service, __ -> duc.setTenantId(service.getTenant()));
        return duc;
    }

    public String normalizeUserCode(String providedCode) {
        return Strings.CI.prependIfMissing(providedCode, (CharSequence)"ODUC-", new CharSequence[0]);
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20DeviceUserCode.class;
    }

    @Generated
    public OAuth20DefaultDeviceUserCodeFactory(UniqueTicketIdGenerator ticketIdGenerator, ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder, int userCodeLength, ServicesManager servicesManager) {
        this.ticketIdGenerator = ticketIdGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.userCodeLength = userCodeLength;
        this.servicesManager = servicesManager;
    }

    @Generated
    public UniqueTicketIdGenerator getTicketIdGenerator() {
        return this.ticketIdGenerator;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20DeviceToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

