/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth20RequestParameterResolver
implements OAuth20RequestParameterResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20RequestParameterResolver.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleArrayElementUnwrapped(true).build().toObjectMapper();
    private final JwtBuilder jwtBuilder;

    public OAuth20ResponseTypes resolveResponseType(WebContext context) {
        List responseTypesSupport = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
        String responseType = this.resolveRequestParameter(context, "response_type").map(String::valueOf).filter(typeName -> responseTypesSupport.stream().anyMatch(supported -> supported.equalsIgnoreCase((String)typeName))).orElse("");
        OAuth20ResponseTypes type = Arrays.stream(OAuth20ResponseTypes.values()).filter(t -> t.getType().equalsIgnoreCase(responseType)).findFirst().orElse(OAuth20ResponseTypes.CODE);
        LOGGER.debug("OAuth response type is [{}]", (Object)type);
        return type;
    }

    public OAuth20GrantTypes resolveGrantType(WebContext context) {
        List grantTypesSupport = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
        String grantType = this.resolveRequestParameter(context, "grant_type").map(String::valueOf).filter(typeName -> grantTypesSupport.stream().anyMatch(supported -> supported.equalsIgnoreCase((String)typeName))).orElse("");
        OAuth20GrantTypes type = Arrays.stream(OAuth20GrantTypes.values()).filter(t -> t.getType().equalsIgnoreCase(grantType)).findFirst().orElse(OAuth20GrantTypes.NONE);
        LOGGER.debug("OAuth grant type is [{}]", (Object)type);
        return type;
    }

    public OAuth20ResponseModeTypes resolveResponseModeType(WebContext context) {
        List supportedResponseModes = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getResponseModesSupported();
        String responseType = this.resolveRequestParameter(context, "response_mode").map(String::valueOf).filter(typeName -> supportedResponseModes.stream().anyMatch(supported -> supported.equalsIgnoreCase((String)typeName))).orElse("");
        OAuth20ResponseModeTypes type = Arrays.stream(OAuth20ResponseModeTypes.values()).filter(t -> t.getType().equalsIgnoreCase(responseType)).findFirst().orElse(OAuth20ResponseModeTypes.NONE);
        LOGGER.debug("OAuth response type is [{}]", (Object)type);
        return type;
    }

    public <T> T resolveJwtRequestParameter(String jwtRequest, RegisteredService registeredService, String name, Class<T> clazz) throws Exception {
        JWTClaimsSet jwt = this.jwtBuilder.unpack(Optional.ofNullable(registeredService), jwtRequest);
        if (clazz.isArray()) {
            return clazz.cast(jwt.getStringArrayClaim(name));
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return clazz.cast(jwt.getStringListClaim(name));
        }
        return clazz.cast(jwt.getStringClaim(name));
    }

    public <T> T resolveJwtRequestParameter(WebContext context, String jwtRequest, String name, Class<T> clazz) {
        String id = context.getRequestParameter("client_id").orElse("");
        OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.jwtBuilder.getServicesManager(), id);
        return (T)FunctionUtils.doUnchecked(() -> this.resolveJwtRequestParameter(jwtRequest, (RegisteredService)service, name, clazz));
    }

    public Map<String, Set<String>> resolveRequestParameters(Collection<String> attributes, WebContext context) {
        return attributes.stream().map(name -> {
            Set values = this.resolveRequestParameter(context, (String)name).map(EncodingUtils::urlDecode).map(value -> Arrays.stream(value.split(" ")).collect(Collectors.toSet())).orElseGet(Set::of);
            return Pair.of((Object)name, (Object)values);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Set<String> resolveRequestParameters(WebContext context, String name) {
        return this.resolveRequestParameters(List.of(name), context).getOrDefault(name, Set.of());
    }

    public Optional<String> resolveRequestParameter(WebContext context, String name) {
        return this.resolveRequestParameter(context, name, String.class);
    }

    public <T> Optional<T> resolveRequestParameter(WebContext context, String name, Class<T> clazz) {
        boolean supported = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().isRequestParameterSupported();
        return context.getRequestParameter("request").filter(parameterValue -> supported).map(Unchecked.function(jwtRequest -> this.resolveJwtRequestParameter(context, (String)jwtRequest, name, clazz))).or(() -> {
            Object[] values = (String[])context.getRequestParameters().get(name);
            if (values != null && values.length > 0) {
                if (clazz.isArray()) {
                    return Optional.of(clazz.cast(values));
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    return Optional.of(clazz.cast(CollectionUtils.wrapArrayList((Object[])values)));
                }
                String singleValue = EncodingUtils.urlDecode((String)values[0]);
                if (Long.class.isAssignableFrom(clazz)) {
                    return Optional.ofNullable(singleValue).map(Long::parseLong).map(clazz::cast);
                }
                if (Integer.class.isAssignableFrom(clazz)) {
                    return Optional.ofNullable(singleValue).map(Integer::parseInt).map(clazz::cast);
                }
                if (Double.class.isAssignableFrom(clazz)) {
                    return Optional.ofNullable(singleValue).map(Double::parseDouble).map(clazz::cast);
                }
                return Optional.ofNullable(singleValue).map(clazz::cast);
            }
            return Optional.empty();
        });
    }

    public Collection<String> resolveRequestedScopes(WebContext context) {
        Map<String, Set<String>> map = this.resolveRequestParameters(CollectionUtils.wrap((Object)"scope"), context);
        if (map == null || map.isEmpty()) {
            return new HashSet<String>();
        }
        List supported = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getScopes();
        LinkedHashSet<String> results = new LinkedHashSet<String>((Collection)map.get("scope"));
        results.retainAll(supported);
        return results;
    }

    public boolean isAuthorizedGrantTypeForService(WebContext context, OAuthRegisteredService registeredService) {
        String grantType = this.resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("");
        return OAuth20RequestParameterResolver.isAuthorizedGrantTypeForService((String)grantType, (OAuthRegisteredService)registeredService);
    }

    public boolean isAuthorizedResponseTypeForService(WebContext context, OAuthRegisteredService registeredService) {
        if (registeredService.getSupportedResponseTypes() != null && !registeredService.getSupportedResponseTypes().isEmpty()) {
            String responseType = this.resolveRequestParameter(context, "response_type").map(String::valueOf).orElse("");
            if (registeredService.getSupportedResponseTypes().stream().anyMatch(s -> s.equalsIgnoreCase(responseType))) {
                return true;
            }
            LOGGER.warn("Response type not authorized for service: [{}] not listed in supported response types: [{}]", (Object)responseType, (Object)registeredService.getSupportedResponseTypes());
            return false;
        }
        LOGGER.warn("Registered service [{}] does not define any authorized/supported response types. It is STRONGLY recommended that you authorize and assign response types to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
        return true;
    }

    public Pair<String, String> resolveClientIdAndClientSecret(CallContext callContext) {
        BasicAuthExtractor extractor = new BasicAuthExtractor();
        Optional upcResult = extractor.extract(callContext);
        if (upcResult.isPresent()) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)upcResult.get();
            return Pair.of((Object)upc.getUsername(), (Object)upc.getPassword());
        }
        String clientId = this.resolveRequestParameter(callContext.webContext(), "client_id").map(String::valueOf).orElse("");
        String clientSecret = this.resolveRequestParameter(callContext.webContext(), "client_secret").map(String::valueOf).orElse("");
        return Pair.of((Object)clientId, (Object)clientSecret);
    }

    public Set<String> resolveRequestScopes(WebContext context) {
        Optional<String> parameterValues = this.resolveRequestParameter(context, "scope");
        if (parameterValues.isEmpty()) {
            return new HashSet<String>();
        }
        List supported = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getScopes();
        Set results = CollectionUtils.wrapSet((Object[])parameterValues.get().split(" "));
        results.retainAll(supported);
        return results;
    }

    public Map<String, Map<String, Object>> resolveRequestClaims(WebContext context) throws Exception {
        boolean supported = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().isClaimsParameterSupported();
        String claims = (String)FunctionUtils.doIf((boolean)supported, () -> this.resolveRequestParameter(context, "claims").map(String::valueOf).orElse(""), () -> "").get();
        if (StringUtils.isBlank((CharSequence)claims)) {
            return new HashMap<String, Map<String, Object>>();
        }
        return (Map)MAPPER.readValue(JsonValue.readHjson((String)claims).toString(), Map.class);
    }

    public Set<String> resolveUserInfoRequestClaims(WebContext context) throws Exception {
        Map<String, Map<String, Object>> requestedClaims = this.resolveRequestClaims(context);
        return ((Map)requestedClaims.getOrDefault("userinfo", new HashMap())).keySet();
    }

    public Set<String> resolveRequestedPromptValues(WebContext context) {
        String url = context.getFullRequestURL();
        return (Set)FunctionUtils.doUnchecked(() -> new URIBuilder(url).getQueryParams().stream().filter(p -> "prompt".equals(p.getName())).map(param -> param.getValue().split(" ")).flatMap(Arrays::stream).collect(Collectors.toSet()));
    }

    public Set<String> resolveSupportedPromptValues(String url) {
        List supported = this.jwtBuilder.getCasProperties().getAuthn().getOidc().getDiscovery().getPromptValuesSupported();
        return (Set)FunctionUtils.doUnchecked(() -> new URIBuilder(url).getQueryParams().stream().filter(p -> "prompt".equals(p.getName())).map(param -> param.getValue().split(" ")).flatMap(Arrays::stream).filter(supported::contains).collect(Collectors.toSet()));
    }

    public boolean isParameterOnQueryString(WebContext context, String name) {
        return WebContextHelper.isQueryStringParameter((WebContext)context, (String)name);
    }

    @Generated
    public DefaultOAuth20RequestParameterResolver(JwtBuilder jwtBuilder) {
        this.jwtBuilder = jwtBuilder;
    }
}

