/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.IndexTemplateCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyIndexTemplateCreator
implements IndexTemplateCreator {
    private static final String INDEX_TEMPLATE_PATH = "/_template/metrics_template";
    private final Logger logger = LoggerFactory.getLogger(LegacyIndexTemplateCreator.class);
    private final HttpSender httpClient;

    LegacyIndexTemplateCreator(HttpSender httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public IndexTemplateCreator.IndexTemplateStatus fetchIndexTemplateStatus(ElasticConfig configuration) {
        HttpSender.Request.Builder request = this.httpClient.head(configuration.host() + INDEX_TEMPLATE_PATH);
        this.configureAuthentication(configuration, request);
        try {
            HttpSender.Response response = request.send();
            switch (response.code()) {
                case 200: {
                    this.logger.debug("Metrics index template already exists at '{}'", (Object)INDEX_TEMPLATE_PATH);
                    return IndexTemplateCreator.IndexTemplateStatus.EXISTS;
                }
                case 404: {
                    this.logger.debug("Metrics index template is missing from '{}'", (Object)INDEX_TEMPLATE_PATH);
                    return IndexTemplateCreator.IndexTemplateStatus.MISSING;
                }
            }
            this.logger.error("Could not create index template in Elastic (HTTP {}): {}", (Object)response.code(), (Object)response.body());
            return IndexTemplateCreator.IndexTemplateStatus.NOT_SUPPORTED;
        }
        catch (Throwable exc) {
            this.logger.error("Could not create index template in Elastic", exc);
            return IndexTemplateCreator.IndexTemplateStatus.NOT_SUPPORTED;
        }
    }

    @Override
    public void createIndexTemplate(ElasticConfig configuration) throws Throwable {
        String indexPattern = configuration.index() + configuration.indexDateSeparator();
        boolean enableSource = configuration.enableSource();
        HttpSender.Request.Builder request = this.httpClient.put(configuration.host() + INDEX_TEMPLATE_PATH);
        this.configureAuthentication(configuration, request);
        request.withJsonContent(this.createIndexTemplateRequestBody(indexPattern, enableSource)).send().onError(response -> this.logger.error("Failed to create index template in Elastic: {}", (Object)response.body()));
    }

    private String createIndexTemplateRequestBody(String indexPattern, boolean enableSource) {
        return String.format("{\n  \"index_patterns\": [\"%s*\"],\n  \"mappings\": {\n    \"_source\": {\n      \"enabled\": %b\n    },\n    \"properties\": {\n      \"name\": { \"type\": \"keyword\" },\n      \"count\": { \"type\": \"double\", \"index\": false },\n      \"value\": { \"type\": \"double\", \"index\": false },\n      \"sum\": { \"type\": \"double\", \"index\": false },\n      \"mean\": { \"type\": \"double\", \"index\": false },\n      \"duration\": { \"type\": \"double\", \"index\": false},\n      \"max\": { \"type\": \"double\", \"index\": false },\n      \"total\": { \"type\": \"double\", \"index\": false },\n      \"unknown\": { \"type\": \"double\", \"index\": false },\n      \"active\": { \"type\": \"double\", \"index\": false }\n    }\n  }\n}", indexPattern, enableSource);
    }
}

