/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PlainAttr
implements Serializable {
    private static final long serialVersionUID = -9115431608821806124L;
    @NotNull
    private String schema;
    @JsonIgnore
    private PlainSchema plainSchema;
    private final List<PlainAttrValue> values = new ArrayList<PlainAttrValue>();
    private PlainAttrValue uniqueValue;
    private String membership;
    private String relationship;

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonIgnore
    public void setPlainSchema(PlainSchema plainSchema) {
        this.plainSchema = plainSchema;
        this.schema = plainSchema.getKey();
    }

    public void add(PlainAttrValue attrValue) {
        this.values.add(attrValue);
    }

    public List<PlainAttrValue> getValues() {
        return this.values;
    }

    public PlainAttrValue getUniqueValue() {
        return this.uniqueValue;
    }

    public void setUniqueValue(PlainAttrValue uniqueValue) {
        this.uniqueValue = uniqueValue;
    }

    @JsonIgnore
    protected PlainSchema fetchPlainSchema() {
        if (this.plainSchema == null) {
            if (this.schema == null) {
                throw new IllegalStateException("First set owner then schema and finally add values");
            }
            this.plainSchema = (PlainSchema)((PlainSchemaDAO)ApplicationContextProvider.getApplicationContext().getBean(PlainSchemaDAO.class)).findById(this.schema).orElseThrow(() -> new NotFoundException("PlainSchema " + this.schema));
        }
        return this.plainSchema;
    }

    public void add(PlainAttrValidationManager validator, String value) {
        PlainAttrValue attrValue = new PlainAttrValue();
        attrValue.setAttr(this);
        this.fetchPlainSchema();
        validator.validate(this.plainSchema, value, attrValue);
        if (this.plainSchema.isUniqueConstraint()) {
            this.setUniqueValue(attrValue);
        } else {
            if (!this.plainSchema.isMultivalue()) {
                this.values.clear();
            }
            this.values.add(attrValue);
        }
    }

    @JsonIgnore
    public List<String> getValuesAsStrings() {
        List<String> result = this.getUniqueValue() == null ? this.getValues().stream().map(PlainAttrValue::getValueAsString).toList() : List.of(this.getUniqueValue().getValueAsString());
        return Collections.unmodifiableList(result);
    }

    public String getMembership() {
        return this.membership;
    }

    public void setMembership(String membership) {
        this.membership = membership;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.membership != null && this.relationship != null) {
            return false;
        }
        boolean validSchema = false;
        try {
            validSchema = this.fetchPlainSchema() != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validSchema && (!this.values.isEmpty() || this.uniqueValue != null);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.schema).append(this.values).append((Object)this.uniqueValue).append((Object)this.membership).append((Object)this.relationship).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlainAttr other = (PlainAttr)obj;
        return new EqualsBuilder().append((Object)this.schema, (Object)other.schema).append(this.values, other.values).append((Object)this.uniqueValue, (Object)other.uniqueValue).append((Object)this.membership, (Object)other.membership).append((Object)this.relationship, (Object)other.relationship).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.schema).append(this.values).append((Object)this.uniqueValue).append((Object)this.membership).append((Object)this.relationship).build();
    }
}

