/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.consent.BaseConsentRepository;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class JsonConsentRepository
extends BaseConsentRepository
implements DisposableBean {
    private static final long serialVersionUID = -402728417464783825L;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final Resource jsonResource;
    private WatcherService watcherService;

    public JsonConsentRepository(Resource resource) throws Exception {
        this.jsonResource = resource;
        this.setConsentDecisions(this.readDecisionsFromJsonResource());
        if (ResourceUtils.isFile((Resource)this.jsonResource)) {
            this.watcherService = new FileWatcherService(resource.getFile(), __ -> this.setConsentDecisions(this.readDecisionsFromJsonResource()));
            this.watcherService.start(this.getClass().getSimpleName());
        }
    }

    public void destroy() {
        FunctionUtils.doIfNotNull((Object)this.watcherService, WatcherService::close);
    }

    @Override
    public ConsentDecision storeConsentDecision(ConsentDecision decision) throws Throwable {
        ConsentDecision result = super.storeConsentDecision(decision);
        this.writeAccountToJsonResource();
        return result;
    }

    @Override
    public boolean deleteConsentDecision(long decisionId, String principal) throws Throwable {
        boolean result = super.deleteConsentDecision(decisionId, principal);
        this.writeAccountToJsonResource();
        return result;
    }

    @Override
    public boolean deleteConsentDecisions(String principal) throws Throwable {
        boolean result = super.deleteConsentDecisions(principal);
        this.writeAccountToJsonResource();
        return result;
    }

    @Override
    public void deleteAll() throws Throwable {
        super.deleteAll();
        this.writeAccountToJsonResource();
    }

    private Set<ConsentDecision> readDecisionsFromJsonResource() {
        return (Set)FunctionUtils.doAndHandle(() -> {
            if (ResourceUtils.doesResourceExist((Resource)this.jsonResource)) {
                try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
                    TypeReference<Set<ConsentDecision>> personList = new TypeReference<Set<ConsentDecision>>(this){};
                    Set set = (Set)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
                    return set;
                }
            }
            return new LinkedHashSet();
        }, throwable -> new LinkedHashSet()).get();
    }

    private void writeAccountToJsonResource() {
        Unchecked.consumer(resource -> {
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(resource.getFile(), this.getConsentDecisions());
            this.readDecisionsFromJsonResource();
        }).accept(this.jsonResource);
    }

    @Generated
    public Resource getJsonResource() {
        return this.jsonResource;
    }

    @Generated
    public WatcherService getWatcherService() {
        return this.watcherService;
    }
}

