/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.task;

import java.io.IOException;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatch;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatchBroker;
import org.apache.flink.runtime.iterative.io.WorksetUpdateOutputCollector;
import org.apache.flink.runtime.iterative.task.AbstractIterativeTask;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterationIntermediateTask<S extends Function, OT>
extends AbstractIterativeTask<S, OT> {
    private static final Logger log = LoggerFactory.getLogger(IterationIntermediateTask.class);
    private WorksetUpdateOutputCollector<OT> worksetUpdateOutputCollector;

    public IterationIntermediateTask(Environment environment) {
        super(environment);
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        Collector delegate = this.getLastOutputCollector();
        if (this.isWorksetUpdate) {
            if (this.isSolutionSetUpdate) {
                throw new IllegalStateException("Plan bug: Intermediate task performs workset and solutions set update.");
            }
            Collector outputCollector = this.createWorksetUpdateOutputCollector(delegate);
            if (this.isWorksetIteration) {
                this.worksetUpdateOutputCollector = (WorksetUpdateOutputCollector)outputCollector;
            }
            this.setLastOutputCollector(outputCollector);
        } else if (this.isSolutionSetUpdate) {
            this.setLastOutputCollector(this.createSolutionSetUpdateOutputCollector(delegate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            SuperstepKickoffLatch nextSuperstepLatch = SuperstepKickoffLatchBroker.instance().get(this.brokerKey());
            while (this.running && !this.terminationRequested()) {
                boolean terminated;
                if (log.isInfoEnabled()) {
                    log.info(this.formatLogString("starting iteration [" + this.currentIteration() + "]"));
                }
                super.run();
                this.verifyEndOfSuperstepState();
                if (this.isWorksetUpdate && this.isWorksetIteration) {
                    long numCollected = this.worksetUpdateOutputCollector.getElementsCollectedAndReset();
                    this.worksetAggregator.aggregate(numCollected);
                }
                if (log.isInfoEnabled()) {
                    log.info(this.formatLogString("finishing iteration [" + this.currentIteration() + "]"));
                }
                this.sendEndOfSuperstep();
                if (this.isWorksetUpdate) {
                    this.worksetBackChannel.notifyOfEndOfSuperstep();
                }
                if (terminated = nextSuperstepLatch.awaitStartOfSuperstepOrTermination(this.currentIteration() + 1)) {
                    this.requestTermination();
                    continue;
                }
                this.incrementIterationCounter();
            }
        }
        finally {
            this.terminationCompleted();
        }
    }

    private void sendEndOfSuperstep() throws IOException, InterruptedException {
        for (RecordWriter eventualOutput : this.eventualOutputs) {
            eventualOutput.broadcastEvent(EndOfSuperstepEvent.INSTANCE);
        }
    }
}

