/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalRecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteRecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.NettyShuffleUtils;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleUtils;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputGateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SingleInputGateFactory.class);
    @Nonnull
    protected final ResourceID taskExecutorResourceId;
    protected final int partitionRequestInitialBackoff;
    protected final int partitionRequestMaxBackoff;
    @Nonnull
    protected final ConnectionManager connectionManager;
    @Nonnull
    protected final ResultPartitionManager partitionManager;
    @Nonnull
    protected final TaskEventPublisher taskEventPublisher;
    @Nonnull
    protected final NetworkBufferPool networkBufferPool;
    protected final int networkBuffersPerChannel;
    private final int floatingNetworkBuffersPerGate;
    private final boolean blockingShuffleCompressionEnabled;
    private final String compressionCodec;
    private final int networkBufferSize;

    public SingleInputGateFactory(@Nonnull ResourceID taskExecutorResourceId, @Nonnull NettyShuffleEnvironmentConfiguration networkConfig, @Nonnull ConnectionManager connectionManager, @Nonnull ResultPartitionManager partitionManager, @Nonnull TaskEventPublisher taskEventPublisher, @Nonnull NetworkBufferPool networkBufferPool) {
        this.taskExecutorResourceId = taskExecutorResourceId;
        this.partitionRequestInitialBackoff = networkConfig.partitionRequestInitialBackoff();
        this.partitionRequestMaxBackoff = networkConfig.partitionRequestMaxBackoff();
        this.networkBuffersPerChannel = NettyShuffleUtils.getNetworkBuffersPerInputChannel(networkConfig.networkBuffersPerChannel());
        this.floatingNetworkBuffersPerGate = networkConfig.floatingNetworkBuffersPerGate();
        this.blockingShuffleCompressionEnabled = networkConfig.isBlockingShuffleCompressionEnabled();
        this.compressionCodec = networkConfig.getCompressionCodec();
        this.networkBufferSize = networkConfig.networkBufferSize();
        this.connectionManager = connectionManager;
        this.partitionManager = partitionManager;
        this.taskEventPublisher = taskEventPublisher;
        this.networkBufferPool = networkBufferPool;
    }

    public SingleInputGate create(@Nonnull String owningTaskName, int gateIndex, @Nonnull InputGateDeploymentDescriptor igdd, @Nonnull PartitionProducerStateProvider partitionProducerStateProvider, @Nonnull InputChannelMetrics metrics) {
        SupplierWithException<BufferPool, IOException> bufferPoolFactory = SingleInputGateFactory.createBufferPoolFactory(this.networkBufferPool, this.floatingNetworkBuffersPerGate);
        BufferDecompressor bufferDecompressor = null;
        if (igdd.getConsumedPartitionType().isBlocking() && this.blockingShuffleCompressionEnabled) {
            bufferDecompressor = new BufferDecompressor(this.networkBufferSize, this.compressionCodec);
        }
        SingleInputGate inputGate = new SingleInputGate(owningTaskName, gateIndex, igdd.getConsumedResultId(), igdd.getConsumedPartitionType(), igdd.getConsumedSubpartitionIndex(), igdd.getShuffleDescriptors().length, partitionProducerStateProvider, bufferPoolFactory, bufferDecompressor, this.networkBufferPool, this.networkBufferSize);
        this.createInputChannels(owningTaskName, igdd, inputGate, metrics);
        return inputGate;
    }

    private void createInputChannels(String owningTaskName, InputGateDeploymentDescriptor inputGateDeploymentDescriptor, SingleInputGate inputGate, InputChannelMetrics metrics) {
        ShuffleDescriptor[] shuffleDescriptors = inputGateDeploymentDescriptor.getShuffleDescriptors();
        InputChannel[] inputChannels = new InputChannel[shuffleDescriptors.length];
        ChannelStatistics channelStatistics = new ChannelStatistics();
        for (int i = 0; i < inputChannels.length; ++i) {
            inputChannels[i] = this.createInputChannel(inputGate, i, shuffleDescriptors[i], channelStatistics, metrics);
        }
        inputGate.setInputChannels(inputChannels);
        LOG.debug("{}: Created {} input channels ({}).", new Object[]{owningTaskName, inputChannels.length, channelStatistics});
    }

    private InputChannel createInputChannel(SingleInputGate inputGate, int index, ShuffleDescriptor shuffleDescriptor, ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        return ShuffleUtils.applyWithShuffleTypeCheck(NettyShuffleDescriptor.class, shuffleDescriptor, unknownShuffleDescriptor -> {
            ++channelStatistics.numUnknownChannels;
            return new UnknownInputChannel(inputGate, index, unknownShuffleDescriptor.getResultPartitionID(), this.partitionManager, this.taskEventPublisher, this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, this.networkBuffersPerChannel, metrics);
        }, nettyShuffleDescriptor -> this.createKnownInputChannel(inputGate, index, (NettyShuffleDescriptor)nettyShuffleDescriptor, channelStatistics, metrics));
    }

    @VisibleForTesting
    protected InputChannel createKnownInputChannel(SingleInputGate inputGate, int index, NettyShuffleDescriptor inputChannelDescriptor, ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        ResultPartitionID partitionId = inputChannelDescriptor.getResultPartitionID();
        if (inputChannelDescriptor.isLocalTo(this.taskExecutorResourceId)) {
            ++channelStatistics.numLocalChannels;
            return new LocalRecoveredInputChannel(inputGate, index, partitionId, this.partitionManager, this.taskEventPublisher, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, this.networkBuffersPerChannel, metrics);
        }
        ++channelStatistics.numRemoteChannels;
        return new RemoteRecoveredInputChannel(inputGate, index, partitionId, inputChannelDescriptor.getConnectionId(), this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, this.networkBuffersPerChannel, metrics);
    }

    @VisibleForTesting
    static SupplierWithException<BufferPool, IOException> createBufferPoolFactory(BufferPoolFactory bufferPoolFactory, int floatingNetworkBuffersPerGate) {
        Pair<Integer, Integer> pair = NettyShuffleUtils.getMinMaxFloatingBuffersPerInputGate(floatingNetworkBuffersPerGate);
        return () -> bufferPoolFactory.createBufferPool((Integer)pair.getLeft(), (Integer)pair.getRight());
    }

    protected static class ChannelStatistics {
        int numLocalChannels;
        int numRemoteChannels;
        int numUnknownChannels;

        protected ChannelStatistics() {
        }

        public String toString() {
            return String.format("local: %s, remote: %s, unknown: %s", this.numLocalChannels, this.numRemoteChannels, this.numUnknownChannels);
        }
    }
}

