/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class JdbcUtils {
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);
    private static final Map<String, DbType> JDBC_DB_TYPE_CACHE = new ConcurrentHashMap<String, DbType>();

    public static DbType getDbType(Executor executor) {
        try {
            Connection conn = executor.getTransaction().getConnection();
            return (DbType)CollectionUtils.computeIfAbsent(JDBC_DB_TYPE_CACHE, (Object)conn.getMetaData().getURL(), JdbcUtils::getDbType);
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }

    public static DbType getDbType(String jdbcUrl) {
        Assert.isFalse((boolean)StringUtils.isBlank((CharSequence)jdbcUrl), (String)"Error: The jdbcUrl is Null, Cannot read database type", (Object[])new Object[0]);
        String url = jdbcUrl.toLowerCase();
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (url.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (url.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (url.contains(":sqlserver:") || url.contains(":microsoft:")) {
            return DbType.SQL_SERVER2005;
        }
        if (url.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (url.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (url.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (url.contains(":db2:")) {
            return DbType.DB2;
        }
        if (url.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (url.contains(":h2:")) {
            return DbType.H2;
        }
        if (JdbcUtils.regexFind(":dm\\d*:", url)) {
            return DbType.DM;
        }
        if (url.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (JdbcUtils.regexFind(":kingbase\\d*:", url)) {
            return DbType.KINGBASE_ES;
        }
        if (url.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (url.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (url.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (url.contains(":gbasedbt-sqli:") || url.contains(":informix-sqli:")) {
            return DbType.GBASE_8S;
        }
        if (url.contains(":ch:") || url.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (url.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (url.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (url.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (url.contains(":highgo:")) {
            return DbType.HIGH_GO;
        }
        if (url.contains(":cubrid:")) {
            return DbType.CUBRID;
        }
        if (url.contains(":goldilocks:")) {
            return DbType.GOLDILOCKS;
        }
        if (url.contains(":csiidb:")) {
            return DbType.CSIIDB;
        }
        if (url.contains(":sap:")) {
            return DbType.SAP_HANA;
        }
        if (url.contains(":impala:")) {
            return DbType.IMPALA;
        }
        if (url.contains(":vertica:")) {
            return DbType.VERTICA;
        }
        if (url.contains(":xcloud:")) {
            return DbType.XCloud;
        }
        if (url.contains(":firebirdsql:")) {
            return DbType.FIREBIRD;
        }
        if (url.contains(":redshift:")) {
            return DbType.REDSHIFT;
        }
        if (url.contains(":opengauss:")) {
            return DbType.OPENGAUSS;
        }
        if (url.contains(":taos:") || url.contains(":taos-rs:")) {
            return DbType.TDENGINE;
        }
        if (url.contains(":informix")) {
            return DbType.INFORMIX;
        }
        if (url.contains(":uxdb:")) {
            return DbType.UXDB;
        }
        logger.warn("The jdbcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!");
        return DbType.OTHER;
    }

    public static boolean regexFind(String regex, CharSequence input) {
        if (null == input) {
            return false;
        }
        return Pattern.compile(regex).matcher(input).find();
    }
}

