/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public enum AlertType {
    EMAIL(1),
    DING_TALK(2),
    WE_COM(4),
    HTTP_CALLBACK(8),
    LARK(16);

    private final Integer code;
    private static Map<Integer, AlertType> cacheMap;

    private AlertType(Integer code) {
        this.code = code;
    }

    public static List<AlertType> decode(Integer level) {
        if (level == null) {
            level = 0;
        }
        ArrayList result = Lists.newArrayList();
        while (level != 0) {
            int code = level & -level.intValue();
            result.add(AlertType.getByCode(code));
            level = level ^ code;
        }
        return result;
    }

    public static int encode(List<AlertType> alertTypes) {
        int result = 0;
        if (!CollectionUtils.isEmpty(alertTypes)) {
            for (AlertType alertType : alertTypes) {
                result |= alertType.code.intValue();
            }
        }
        return result;
    }

    private static AlertType getByCode(Integer code) {
        if (cacheMap == null) {
            cacheMap = new HashMap<Integer, AlertType>();
            for (AlertType notifyType : AlertType.values()) {
                cacheMap.put(notifyType.code, notifyType);
            }
        }
        return cacheMap.get(code);
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }
}

