/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.entity.YarnQueue;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/yarnQueue"})
public class YarnQueueController {
    private static final Logger log = LoggerFactory.getLogger(YarnQueueController.class);
    @Autowired
    private YarnQueueService yarnQueueService;

    @PostMapping(value={"list"})
    public RestResponse list(RestRequest restRequest, YarnQueue yarnQueue) {
        IPage<YarnQueue> queuePage = this.yarnQueueService.page(yarnQueue, restRequest);
        return RestResponse.success(queuePage);
    }

    @PostMapping(value={"check"})
    public RestResponse check(YarnQueue yarnQueue) {
        return RestResponse.success(this.yarnQueueService.checkYarnQueue(yarnQueue));
    }

    @PostMapping(value={"create"})
    @RequiresPermissions(value={"yarnQueue:create"})
    public RestResponse create(YarnQueue yarnQueue) {
        return RestResponse.success(this.yarnQueueService.createYarnQueue(yarnQueue));
    }

    @PostMapping(value={"update"})
    @RequiresPermissions(value={"yarnQueue:update"})
    public RestResponse update(YarnQueue yarnQueue) {
        this.yarnQueueService.updateYarnQueue(yarnQueue);
        return RestResponse.success();
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"yarnQueue:delete"})
    public RestResponse delete(YarnQueue yarnQueue) {
        this.yarnQueueService.deleteYarnQueue(yarnQueue);
        return RestResponse.success();
    }
}

