/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitUtils {
    private GitUtils() {
    }

    public static Git clone(GitCloneRequest request) throws GitAPIException {
        try {
            CloneCommand cloneCommand = Git.cloneRepository().setURI(request.getUrl()).setDirectory(request.getStoreDir());
            GitUtils.setCredentials(cloneCommand, request);
            if (StringUtils.isNotBlank((CharSequence)request.getBranch())) {
                cloneCommand.setBranch("refs/heads/" + request.getBranch());
                cloneCommand.setBranchesToClone(Collections.singletonList("refs/heads/" + request.getBranch()));
            }
            Git git = cloneCommand.call();
            if (StringUtils.isNotBlank((CharSequence)request.getBranch())) {
                git.checkout().setName(request.getBranch()).call();
            } else if (StringUtils.isNotBlank((CharSequence)request.getTag())) {
                git.checkout().setName(request.getTag()).call();
            } else {
                throw new IllegalArgumentException("git clone failed, No tag or branch specified");
            }
            return git;
        }
        catch (Exception e) {
            if (e instanceof InvalidRemoteException && request.getConnType() == GitConnType.HTTP) {
                String url = GitUtils.httpUrlToSSH(request.getUrl());
                request.setUrl(url);
                return GitUtils.clone(request);
            }
            throw e;
        }
    }

    public static List<String> getBranches(GitGetRequest request) throws GitAPIException {
        try {
            LsRemoteCommand command = Git.lsRemoteRepository().setRemote(request.getUrl()).setHeads(true);
            GitUtils.setCredentials(command, request);
            Collection refList = command.call();
            ArrayList<String> branchList = new ArrayList<String>(4);
            for (Ref ref : refList) {
                String refName = ref.getName();
                if (!refName.startsWith("refs/heads/")) continue;
                String branchName = refName.replace("refs/heads/", "");
                branchList.add(branchName);
            }
            return branchList;
        }
        catch (Exception e) {
            if (e instanceof InvalidRemoteException && request.getConnType() == GitConnType.HTTP) {
                String url = GitUtils.httpUrlToSSH(request.getUrl());
                request.setUrl(url);
                return GitUtils.getBranches(request);
            }
            throw e;
        }
    }

    public static List<String> getTags(GitGetRequest request) throws GitAPIException {
        try {
            LsRemoteCommand command = Git.lsRemoteRepository().setRemote(request.getUrl()).setTags(true);
            GitUtils.setCredentials(command, request);
            Collection refList = command.call();
            ArrayList<String> tagList = new ArrayList<String>(4);
            for (Ref ref : refList) {
                String refName = ref.getName();
                if (!refName.startsWith("refs/tags/")) continue;
                String branchName = refName.replace("refs/tags/", "");
                tagList.add(branchName);
            }
            return tagList;
        }
        catch (Exception e) {
            if (e instanceof InvalidRemoteException && request.getConnType() == GitConnType.HTTP) {
                String url = GitUtils.httpUrlToSSH(request.getUrl());
                request.setUrl(url);
                return GitUtils.getTags(request);
            }
            throw e;
        }
    }

    public static String httpUrlToSSH(String url) {
        return url.replaceAll("(https://|http://)(.*?)/(.*?)/(.*?)(\\.git|)\\s*$", "git@$2:$3/$4.git");
    }

    public static boolean isSshRepositoryUrl(String url) {
        return url.trim().startsWith("git@");
    }

    public static boolean isHttpRepositoryUrl(String url) {
        return !GitUtils.isSshRepositoryUrl(url);
    }

    private static void setCredentials(TransportCommand<?, ?> transportCommand, final GitAuthRequest request) {
        switch (request.connType) {
            case HTTP: {
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{request.getUsername(), request.getPassword()})) break;
                UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(request.getUsername(), request.getPassword());
                transportCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                break;
            }
            case SSH: {
                transportCommand.setTransportConfigCallback(transport -> {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                        protected void configure(OpenSshConfig.Host hc, Session session) {
                            session.setConfig("StrictHostKeyChecking", "no");
                        }

                        protected JSch createDefaultJSch(FS fs) throws JSchException {
                            String rsaPath;
                            File resFile;
                            String userHome;
                            JSch jSch = super.createDefaultJSch(fs);
                            String prvkeyPath = request.getPrivateKey();
                            if (StringUtils.isBlank((CharSequence)prvkeyPath) && (userHome = System.getProperty("user.home")) != null && (resFile = new File(rsaPath = userHome.concat("/.ssh/id_rsa"))).exists()) {
                                prvkeyPath = rsaPath;
                            }
                            if (prvkeyPath == null) {
                                return jSch;
                            }
                            if (StringUtils.isEmpty((CharSequence)request.getPassword())) {
                                jSch.addIdentity(prvkeyPath);
                            } else {
                                jSch.addIdentity(prvkeyPath, request.getPassword());
                            }
                            return jSch;
                        }
                    });
                });
                break;
            }
            default: {
                throw new IllegalStateException("[StreamPark] repository URL is invalid, must be ssh or http(s)");
            }
        }
    }

    public static class GitCloneRequest
    extends GitGetRequest {
        private File storeDir;
        private String branch;
        private String tag;

        public void setRefs(String refs) {
            if (StringUtils.isNotBlank((CharSequence)refs)) {
                if (!refs.startsWith("refs/")) {
                    this.branch = refs;
                    return;
                }
                if (refs.startsWith("refs/heads/")) {
                    this.branch = refs.replace("refs/heads/", "");
                    return;
                }
                if (refs.startsWith("refs/tags/")) {
                    this.tag = refs.replace("refs/tags/", "");
                }
            }
        }

        public File getStoreDir() {
            return this.storeDir;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getTag() {
            return this.tag;
        }

        public void setStoreDir(File storeDir) {
            this.storeDir = storeDir;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public static class GitGetRequest
    extends GitAuthRequest {
        private String url;

        public void setUrl(String url) {
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new IllegalArgumentException("git url cannot be empty");
            }
            this.url = url;
            if (GitUtils.isSshRepositoryUrl(url)) {
                this.setConnType(GitConnType.SSH);
            } else {
                this.setConnType(GitConnType.HTTP);
            }
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class GitAuthRequest {
        private GitConnType connType;
        private String username;
        private String password;
        private String privateKey;

        public GitConnType getConnType() {
            return this.connType;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setConnType(GitConnType connType) {
            this.connType = connType;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }
    }

    public static enum GitConnType {
        HTTP,
        SSH;

    }
}

