/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.deploy.internal;

import java.util.Collection;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.transfer.artifact.deploy.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.deploy.internal.MavenArtifactDeployer;
import org.apache.maven.shared.transfer.metadata.ArtifactMetadata;
import org.apache.maven.shared.transfer.metadata.internal.Maven31MetadataBridge;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

class Maven31ArtifactDeployer
implements MavenArtifactDeployer {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    Maven31ArtifactDeployer(RepositorySystem repositorySystem, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.session = session;
    }

    @Override
    public void deploy(Collection<org.apache.maven.artifact.Artifact> mavenArtifacts) throws ArtifactDeployerException {
        this.deploy(null, mavenArtifacts);
    }

    @Override
    public void deploy(ArtifactRepository remoteRepository, Collection<org.apache.maven.artifact.Artifact> mavenArtifacts) throws ArtifactDeployerException {
        DeployRequest request = new DeployRequest();
        RemoteRepository defaultRepository = null;
        if (remoteRepository != null) {
            defaultRepository = this.getRemoteRepository(this.session, remoteRepository);
        }
        for (org.apache.maven.artifact.Artifact mavenArtifact : mavenArtifacts) {
            Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
            request.addArtifact(aetherArtifact);
            RemoteRepository aetherRepository = remoteRepository == null ? this.getRemoteRepository(this.session, mavenArtifact.getRepository()) : defaultRepository;
            request.setRepository(aetherRepository);
            for (org.apache.maven.artifact.metadata.ArtifactMetadata metadata : mavenArtifact.getMetadataList()) {
                if (metadata instanceof ProjectArtifactMetadata) {
                    SubArtifact pomArtifact = new SubArtifact(aetherArtifact, "", "pom");
                    pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                    request.addArtifact((Artifact)pomArtifact);
                    continue;
                }
                if (metadata instanceof ArtifactRepositoryMetadata || !(metadata instanceof ArtifactMetadata)) continue;
                ArtifactMetadata transferMetadata = (ArtifactMetadata)metadata;
                request.addMetadata(new Maven31MetadataBridge(metadata).setFile(transferMetadata.getFile()));
            }
        }
        try {
            this.repositorySystem.deploy(this.session, request);
        }
        catch (DeploymentException e) {
            throw new ArtifactDeployerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private RemoteRepository getRemoteRepository(RepositorySystemSession session, ArtifactRepository remoteRepository) throws ArtifactDeployerException {
        RemoteRepository aetherRepo = (RemoteRepository)Invoker.invoke(RepositoryUtils.class, "toRepo", ArtifactRepository.class, (Object)remoteRepository);
        if (aetherRepo.getAuthentication() == null || aetherRepo.getProxy() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(aetherRepo);
            if (aetherRepo.getAuthentication() == null) {
                builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(aetherRepo));
            }
            if (aetherRepo.getProxy() == null) {
                builder.setProxy(session.getProxySelector().getProxy(aetherRepo));
            }
            aetherRepo = builder.build();
        }
        return aetherRepo;
    }
}

