/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.CombinedWatermarkStatus;
import org.apache.flink.util.Preconditions;

@Internal
public final class IndexedCombinedWatermarkStatus {
    private final CombinedWatermarkStatus combinedWatermarkStatus;
    private final CombinedWatermarkStatus.PartialWatermark[] partialWatermarks;

    private IndexedCombinedWatermarkStatus(CombinedWatermarkStatus combinedWatermarkStatus, CombinedWatermarkStatus.PartialWatermark[] partialWatermarks) {
        this.combinedWatermarkStatus = combinedWatermarkStatus;
        this.partialWatermarks = partialWatermarks;
    }

    public static IndexedCombinedWatermarkStatus forInputsCount(int inputsCount) {
        CombinedWatermarkStatus.PartialWatermark[] partialWatermarks = (CombinedWatermarkStatus.PartialWatermark[])IntStream.range(0, inputsCount).mapToObj(i -> new CombinedWatermarkStatus.PartialWatermark()).toArray(CombinedWatermarkStatus.PartialWatermark[]::new);
        CombinedWatermarkStatus combinedWatermarkStatus = new CombinedWatermarkStatus();
        for (CombinedWatermarkStatus.PartialWatermark partialWatermark : partialWatermarks) {
            combinedWatermarkStatus.add(partialWatermark);
        }
        return new IndexedCombinedWatermarkStatus(combinedWatermarkStatus, partialWatermarks);
    }

    public boolean updateWatermark(int index, long timestamp) {
        Preconditions.checkArgument(index < this.partialWatermarks.length);
        this.partialWatermarks[index].setWatermark(timestamp);
        return this.combinedWatermarkStatus.updateCombinedWatermark();
    }

    public long getCombinedWatermark() {
        return this.combinedWatermarkStatus.getCombinedWatermark();
    }

    public boolean updateStatus(int index, boolean idle) {
        Preconditions.checkArgument(index < this.partialWatermarks.length);
        this.partialWatermarks[index].setIdle(idle);
        return this.combinedWatermarkStatus.updateCombinedWatermark();
    }

    public boolean isIdle() {
        return this.combinedWatermarkStatus.isIdle();
    }
}

