/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.security.impl;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.util.ShaHashUtils;
import org.apache.streampark.console.core.enums.LoginType;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.security.Authenticator;
import org.apache.streampark.console.system.security.impl.LdapService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthenticatorImpl
implements Authenticator {
    @Autowired
    private UserService usersService;
    @Autowired
    private LdapService ldapService;

    @Override
    public User authenticate(String username, String password, LoginType loginType) throws Exception {
        if (loginType == null) {
            throw new ApiAlertException(String.format("the login type is null.", new Object[0]));
        }
        if (loginType.equals((Object)LoginType.PASSWORD)) {
            return this.passwordAuthenticate(username, password);
        }
        return this.ldapAuthenticate(username, password);
    }

    private User passwordAuthenticate(String username, String password) {
        User user = this.usersService.findByName(username);
        if (user == null || user.getLoginType() != LoginType.PASSWORD) {
            throw new ApiAlertException(String.format("user [%s] does not exist or can not login with PASSWORD", username));
        }
        String salt = user.getSalt();
        password = ShaHashUtils.encrypt(salt, password);
        if (!StringUtils.equals((CharSequence)user.getPassword(), (CharSequence)password)) {
            return null;
        }
        return user;
    }

    private User ldapAuthenticate(String username, String password) throws Exception {
        String ldapEmail = this.ldapService.ldapLogin(username, password);
        if (ldapEmail == null) {
            return null;
        }
        User user = this.usersService.findByName(username);
        if (user != null) {
            if (user.getLoginType() != LoginType.LDAP) {
                throw new ApiAlertException(String.format("user [%s] can only sign in with %s", new Object[]{username, user.getLoginType()}));
            }
            String saltPassword = ShaHashUtils.encrypt(user.getSalt(), password);
            if (!StringUtils.equals((CharSequence)saltPassword, (CharSequence)user.getPassword())) {
                String salt = ShaHashUtils.getRandomSalt();
                saltPassword = ShaHashUtils.encrypt(salt, password);
                user.setSalt(salt);
                user.setPassword(saltPassword);
                this.usersService.updateSaltPassword(user);
            }
            return user;
        }
        User newUser = new User();
        newUser.setCreateTime(new Date());
        newUser.setUsername(username);
        newUser.setNickName(username);
        newUser.setUserType(UserType.USER);
        newUser.setLoginType(LoginType.LDAP);
        newUser.setStatus("1");
        newUser.setSex("2");
        newUser.setPassword(password);
        this.usersService.createUser(newUser);
        return newUser;
    }
}

