/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.console.core.enums.LoginType;
import org.apache.streampark.console.core.enums.UserType;

@TableName(value="t_user")
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_VALID = "1";
    public static final String STATUS_LOCK = "0";
    public static final String SEX_MALE = "0";
    public static final String SEX_FEMALE = "1";
    public static final String SEX_UNKNOWN = "2";
    public static final Integer DEFAULT_PASSWORD_LENGTH = 8;
    @TableId(type=IdType.AUTO)
    private Long userId;
    @Size(min=4, max=20, message="{range}")
    private @Size(min=4, max=20, message="{range}") String username;
    private String password;
    @Size(max=50, message="{noMoreThan}")
    @Email(message="{email}")
    private @Size(max=50, message="{noMoreThan}") @Email(message="{email}") String email;
    private UserType userType;
    private LoginType loginType;
    @NotBlank(message="{required}")
    private @NotBlank(message="{required}") String status;
    private Date createTime;
    private Date modifyTime;
    private Date lastLoginTime;
    @NotBlank(message="{required}")
    private @NotBlank(message="{required}") String sex;
    @Size(max=100, message="{noMoreThan}")
    private @Size(max=100, message="{noMoreThan}") String description;
    private transient String oldPassword;
    private transient String createTimeFrom;
    private transient String createTimeTo;
    private transient String id;
    private String salt;
    private String nickName;
    private Long lastTeamId;

    public void dataMasking() {
        String dataMask = ConfigConst.DEFAULT_DATAMASK_STRING();
        this.setPassword(dataMask);
        this.setSalt(dataMask);
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getSex() {
        return this.sex;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getCreateTimeFrom() {
        return this.createTimeFrom;
    }

    public String getCreateTimeTo() {
        return this.createTimeTo;
    }

    public String getId() {
        return this.id;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getNickName() {
        return this.nickName;
    }

    public Long getLastTeamId() {
        return this.lastTeamId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public void setCreateTimeFrom(String createTimeFrom) {
        this.createTimeFrom = createTimeFrom;
    }

    public void setCreateTimeTo(String createTimeTo) {
        this.createTimeTo = createTimeTo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setLastTeamId(Long lastTeamId) {
        this.lastTeamId = lastTeamId;
    }
}

