/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.metrics.AbstractLatencyTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;
import org.apache.flink.util.function.ThrowingRunnable;

class LatencyTrackingMapState<K, N, UK, UV>
extends AbstractLatencyTrackState<K, N, Map<UK, UV>, InternalMapState<K, N, UK, UV>, MapStateLatencyMetrics>
implements InternalMapState<K, N, UK, UV> {
    LatencyTrackingMapState(String stateName, InternalMapState<K, N, UK, UV> original, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        super(original, new MapStateLatencyMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()));
    }

    public UV get(UK key) throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnGet()) {
            return (UV)this.trackLatencyWithException(() -> ((InternalMapState)this.original).get(key), "mapStateGetLatency");
        }
        return (UV)((InternalMapState)this.original).get(key);
    }

    public void put(UK key, UV value) throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnPut()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalMapState)this.original).put(key, value)), "mapStatePutLatency");
        } else {
            ((InternalMapState)this.original).put(key, value);
        }
    }

    public void putAll(Map<UK, UV> map) throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnPutAll()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalMapState)this.original).putAll(map)), "mapStatePutAllLatency");
        } else {
            ((InternalMapState)this.original).putAll(map);
        }
    }

    public void remove(UK key) throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnRemove()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalMapState)this.original).remove(key)), "mapStateRemoveLatency");
        } else {
            ((InternalMapState)this.original).remove(key);
        }
    }

    public boolean contains(UK key) throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnContains()) {
            return (Boolean)this.trackLatencyWithException(() -> ((InternalMapState)this.original).contains(key), "mapStateContainsLatency");
        }
        return ((InternalMapState)this.original).contains(key);
    }

    public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnEntriesInit()) {
            return (Iterable)this.trackLatencyWithException(() -> new IterableWrapper(((InternalMapState)this.original).entries()), "mapStateEntriesInitLatency");
        }
        return new IterableWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).entries());
    }

    public Iterable<UK> keys() throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnKeysInit()) {
            return (Iterable)this.trackLatencyWithException(() -> new IterableWrapper(((InternalMapState)this.original).keys()), "mapStateKeysInitLatency");
        }
        return new IterableWrapper(((InternalMapState)this.original).keys());
    }

    public Iterable<UV> values() throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnValuesInit()) {
            return (Iterable)this.trackLatencyWithException(() -> new IterableWrapper(((InternalMapState)this.original).values()), "mapStateValuesInitLatency");
        }
        return new IterableWrapper(((InternalMapState)this.original).values());
    }

    public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnIteratorInit()) {
            return (Iterator)this.trackLatencyWithException(() -> new IteratorWrapper(((InternalMapState)this.original).iterator()), "mapStateIteratorInitLatency");
        }
        return new IteratorWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).iterator());
    }

    public boolean isEmpty() throws Exception {
        if (((MapStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnIsEmpty()) {
            return (Boolean)this.trackLatencyWithException(() -> ((InternalMapState)this.original).isEmpty(), "mapStateIsEmptyLatency");
        }
        return ((InternalMapState)this.original).isEmpty();
    }

    static class MapStateLatencyMetrics
    extends StateLatencyMetricBase {
        private static final String MAP_STATE_GET_LATENCY = "mapStateGetLatency";
        private static final String MAP_STATE_PUT_LATENCY = "mapStatePutLatency";
        private static final String MAP_STATE_PUT_ALL_LATENCY = "mapStatePutAllLatency";
        private static final String MAP_STATE_REMOVE_LATENCY = "mapStateRemoveLatency";
        private static final String MAP_STATE_CONTAINS_LATENCY = "mapStateContainsLatency";
        private static final String MAP_STATE_ENTRIES_INIT_LATENCY = "mapStateEntriesInitLatency";
        private static final String MAP_STATE_KEYS_INIT_LATENCY = "mapStateKeysInitLatency";
        private static final String MAP_STATE_VALUES_INIT_LATENCY = "mapStateValuesInitLatency";
        private static final String MAP_STATE_ITERATOR_INIT_LATENCY = "mapStateIteratorInitLatency";
        private static final String MAP_STATE_IS_EMPTY_LATENCY = "mapStateIsEmptyLatency";
        private static final String MAP_STATE_ITERATOR_HAS_NEXT_LATENCY = "mapStateIteratorHasNextLatency";
        private static final String MAP_STATE_ITERATOR_NEXT_LATENCY = "mapStateIteratorNextLatency";
        private static final String MAP_STATE_ITERATOR_REMOVE_LATENCY = "mapStateIteratorRemoveLatency";
        private int getCount = 0;
        private int iteratorRemoveCount = 0;
        private int putCount = 0;
        private int putAllCount = 0;
        private int removeCount = 0;
        private int containsCount = 0;
        private int entriesInitCount = 0;
        private int keysInitCount = 0;
        private int valuesInitCount = 0;
        private int isEmptyCount = 0;
        private int iteratorInitCount = 0;
        private int iteratorHasNextCount = 0;
        private int iteratorNextCount = 0;

        private MapStateLatencyMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getIteratorRemoveCount() {
            return this.iteratorRemoveCount;
        }

        int getPutCount() {
            return this.putCount;
        }

        int getPutAllCount() {
            return this.putAllCount;
        }

        int getRemoveCount() {
            return this.removeCount;
        }

        int getContainsCount() {
            return this.containsCount;
        }

        int getEntriesInitCount() {
            return this.entriesInitCount;
        }

        int getKeysInitCount() {
            return this.keysInitCount;
        }

        int getValuesInitCount() {
            return this.valuesInitCount;
        }

        int getIsEmptyCount() {
            return this.isEmptyCount;
        }

        int getIteratorInitCount() {
            return this.iteratorInitCount;
        }

        int getIteratorHasNextCount() {
            return this.iteratorHasNextCount;
        }

        @VisibleForTesting
        void resetIteratorHasNextCount() {
            this.iteratorHasNextCount = 0;
        }

        int getIteratorNextCount() {
            return this.iteratorNextCount;
        }

        private boolean trackLatencyOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackLatencyOnPut() {
            this.putCount = this.loopUpdateCounter(this.putCount);
            return this.putCount == 1;
        }

        private boolean trackLatencyOnPutAll() {
            this.putAllCount = this.loopUpdateCounter(this.putAllCount);
            return this.putAllCount == 1;
        }

        private boolean trackLatencyOnRemove() {
            this.removeCount = this.loopUpdateCounter(this.removeCount);
            return this.removeCount == 1;
        }

        private boolean trackLatencyOnContains() {
            this.containsCount = this.loopUpdateCounter(this.containsCount);
            return this.containsCount == 1;
        }

        private boolean trackLatencyOnEntriesInit() {
            this.entriesInitCount = this.loopUpdateCounter(this.entriesInitCount);
            return this.entriesInitCount == 1;
        }

        private boolean trackLatencyOnKeysInit() {
            this.keysInitCount = this.loopUpdateCounter(this.keysInitCount);
            return this.keysInitCount == 1;
        }

        private boolean trackLatencyOnValuesInit() {
            this.valuesInitCount = this.loopUpdateCounter(this.valuesInitCount);
            return this.valuesInitCount == 1;
        }

        private boolean trackLatencyOnIteratorInit() {
            this.iteratorInitCount = this.loopUpdateCounter(this.iteratorInitCount);
            return this.iteratorInitCount == 1;
        }

        private boolean trackLatencyOnIsEmpty() {
            this.isEmptyCount = this.loopUpdateCounter(this.isEmptyCount);
            return this.isEmptyCount == 1;
        }

        private boolean trackLatencyOnIteratorHasNext() {
            this.iteratorHasNextCount = this.loopUpdateCounter(this.iteratorHasNextCount);
            return this.iteratorHasNextCount == 1;
        }

        private boolean trackLatencyOnIteratorNext() {
            this.iteratorNextCount = this.loopUpdateCounter(this.iteratorNextCount);
            return this.iteratorNextCount == 1;
        }

        private boolean trackLatencyOnIteratorRemove() {
            this.iteratorRemoveCount = this.loopUpdateCounter(this.iteratorRemoveCount);
            return this.iteratorRemoveCount == 1;
        }
    }

    private class IteratorWrapper<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        IteratorWrapper(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (((MapStateLatencyMetrics)LatencyTrackingMapState.this.latencyTrackingStateMetric).trackLatencyOnIteratorHasNext()) {
                return LatencyTrackingMapState.this.trackLatency(this.iterator::hasNext, "mapStateIteratorHasNextLatency");
            }
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (((MapStateLatencyMetrics)LatencyTrackingMapState.this.latencyTrackingStateMetric).trackLatencyOnIteratorNext()) {
                return (E)LatencyTrackingMapState.this.trackLatency(this.iterator::next, "mapStateIteratorNextLatency");
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            if (((MapStateLatencyMetrics)LatencyTrackingMapState.this.latencyTrackingStateMetric).trackLatencyOnIteratorRemove()) {
                LatencyTrackingMapState.this.trackLatency(this.iterator::remove, "mapStateIteratorRemoveLatency");
            } else {
                this.iterator.remove();
            }
        }
    }

    private class IterableWrapper<E>
    implements Iterable<E> {
        private final Iterable<E> iterable;

        IterableWrapper(Iterable<E> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorWrapper<E>(this.iterable.iterator());
        }
    }
}

