/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;

public class Distinct {
    private List<SelectItem> onSelectItems;
    private boolean useUnique = false;

    public Distinct() {
    }

    public Distinct(boolean useUnique) {
        this.useUnique = useUnique;
    }

    public List<SelectItem> getOnSelectItems() {
        return this.onSelectItems;
    }

    public void setOnSelectItems(List<SelectItem> list) {
        this.onSelectItems = list;
    }

    public boolean isUseUnique() {
        return this.useUnique;
    }

    public void setUseUnique(boolean useUnique) {
        this.useUnique = useUnique;
    }

    public String toString() {
        String sql;
        String string = sql = this.useUnique ? "UNIQUE" : "DISTINCT";
        if (this.onSelectItems != null && !this.onSelectItems.isEmpty()) {
            sql = sql + " ON (" + PlainSelect.getStringList(this.onSelectItems) + ")";
        }
        return sql;
    }

    public Distinct withOnSelectItems(List<SelectItem> onSelectItems) {
        this.setOnSelectItems(onSelectItems);
        return this;
    }

    public Distinct withUseUnique(boolean useUnique) {
        this.setUseUnique(useUnique);
        return this;
    }

    public Distinct addOnSelectItems(SelectItem ... onSelectItems) {
        List collection = Optional.ofNullable(this.getOnSelectItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, onSelectItems);
        return this.withOnSelectItems(collection);
    }

    public Distinct addOnSelectItems(Collection<? extends SelectItem> onSelectItems) {
        List collection = Optional.ofNullable(this.getOnSelectItems()).orElseGet(ArrayList::new);
        collection.addAll(onSelectItems);
        return this.withOnSelectItems(collection);
    }
}

