/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.async.UnknownOperationKeyException;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.types.Either;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class CompletedOperationCache<K extends OperationKey, R>
implements AutoCloseableAsync {
    private static final long COMPLETED_OPERATION_RESULT_CACHE_DURATION_SECONDS = 300L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletedOperationCache.class);
    private final Map<K, ResultAccessTracker<R>> registeredOperationTriggers = new ConcurrentHashMap<K, ResultAccessTracker<R>>();
    private final Cache<K, ResultAccessTracker<R>> completedOperations;
    private final Object lock = new Object();
    @Nullable
    private CompletableFuture<Void> terminationFuture;

    CompletedOperationCache() {
        this(Ticker.systemTicker());
    }

    @VisibleForTesting
    CompletedOperationCache(Ticker ticker) {
        this.completedOperations = CacheBuilder.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).removalListener(removalNotification -> {
            if (removalNotification.wasEvicted()) {
                Preconditions.checkState((removalNotification.getKey() != null ? 1 : 0) != 0);
                Preconditions.checkState((removalNotification.getValue() != null ? 1 : 0) != 0);
                ((ResultAccessTracker)removalNotification.getValue()).markAccessed();
                LOGGER.info("Evicted result with trigger id {} because its TTL of {}s has expired.", (Object)((OperationKey)removalNotification.getKey()).getTriggerId(), (Object)300L);
            }
        }).ticker(ticker).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOngoingOperation(K operationKey, CompletableFuture<R> operationResultFuture) {
        ResultAccessTracker inProgress = ResultAccessTracker.inProgress();
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isRunning(), (Object)"The CompletedOperationCache has already been closed.");
            this.registeredOperationTriggers.put(operationKey, inProgress);
        }
        operationResultFuture.whenComplete((result, error) -> {
            if (error == null) {
                this.completedOperations.put((Object)operationKey, inProgress.finishOperation(Either.Right((Object)result)));
            } else {
                this.completedOperations.put((Object)operationKey, inProgress.finishOperation(Either.Left((Object)error)));
            }
            this.registeredOperationTriggers.remove(operationKey);
        });
    }

    @GuardedBy(value="lock")
    private boolean isRunning() {
        return this.terminationFuture == null;
    }

    @Nullable
    public Either<Throwable, R> get(K operationKey) throws UnknownOperationKeyException {
        ResultAccessTracker resultAccessTracker = this.registeredOperationTriggers.get(operationKey);
        if (resultAccessTracker == null && (resultAccessTracker = (ResultAccessTracker)this.completedOperations.getIfPresent(operationKey)) == null) {
            throw new UnknownOperationKeyException(operationKey);
        }
        return resultAccessTracker.accessOperationResultOrError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.terminationFuture = FutureUtils.orTimeout(this.asyncWaitForResultsToBeAccessed(), (long)300L, (TimeUnit)TimeUnit.SECONDS);
            }
            return this.terminationFuture;
        }
    }

    private CompletableFuture<Void> asyncWaitForResultsToBeAccessed() {
        return FutureUtils.waitForAll((Collection)Stream.concat(this.registeredOperationTriggers.values().stream(), this.completedOperations.asMap().values().stream()).map(ResultAccessTracker::getAccessedFuture).collect(Collectors.toList()));
    }

    @VisibleForTesting
    void cleanUp() {
        this.completedOperations.cleanUp();
    }

    private static class ResultAccessTracker<R> {
        @Nullable
        private final Either<Throwable, R> operationResultOrError;
        private final CompletableFuture<Void> accessed;

        private static <R> ResultAccessTracker<R> inProgress() {
            return new ResultAccessTracker<R>();
        }

        private ResultAccessTracker() {
            this.operationResultOrError = null;
            this.accessed = new CompletableFuture();
        }

        private ResultAccessTracker(Either<Throwable, R> operationResultOrError, CompletableFuture<Void> accessed) {
            this.operationResultOrError = (Either)Preconditions.checkNotNull(operationResultOrError);
            this.accessed = (CompletableFuture)Preconditions.checkNotNull(accessed);
        }

        public ResultAccessTracker<R> finishOperation(Either<Throwable, R> operationResultOrError) {
            Preconditions.checkState((this.operationResultOrError == null ? 1 : 0) != 0);
            return new ResultAccessTracker<R>((Either)Preconditions.checkNotNull(operationResultOrError), this.accessed);
        }

        @Nullable
        public Either<Throwable, R> accessOperationResultOrError() {
            if (this.operationResultOrError != null) {
                this.markAccessed();
            }
            return this.operationResultOrError;
        }

        public CompletableFuture<Void> getAccessedFuture() {
            return this.accessed;
        }

        private void markAccessed() {
            this.accessed.complete(null);
        }
    }
}

