/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.MemberService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"member"})
public class MemberController {
    private static final Logger log = LoggerFactory.getLogger(MemberController.class);
    @Autowired
    private MemberService memberService;

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"member:view"})
    public RestResponse memberList(RestRequest restRequest, Member member) {
        IPage<Member> userList = this.memberService.page(member, restRequest);
        return RestResponse.success(userList);
    }

    @PostMapping(value={"candidateUsers"})
    @RequiresPermissions(value={"member:add"})
    public RestResponse candidateUsers(Long teamId) {
        List<User> userList = this.memberService.findCandidateUsers(teamId);
        return RestResponse.success(userList);
    }

    @PostMapping(value={"teams"})
    public RestResponse listTeams(Long userId) {
        List<Team> teamList = this.memberService.findUserTeams(userId);
        return RestResponse.success(teamList);
    }

    @PostMapping(value={"check/user"})
    public RestResponse check(@NotBlank(message="{required}") @NotBlank(message="{required}") Long teamId, String userName) {
        Member result = this.memberService.findByUserName(teamId, userName);
        return RestResponse.success(result == null);
    }

    @PermissionScope(team="#member.teamId")
    @PostMapping(value={"post"})
    @RequiresPermissions(value={"member:add"})
    public RestResponse create(@Valid Member member) {
        this.memberService.createMember(member);
        return RestResponse.success();
    }

    @PermissionScope(team="#member.teamId")
    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"member:delete"})
    public RestResponse delete(Member member) {
        this.memberService.deleteMember(member);
        return RestResponse.success();
    }

    @PermissionScope(team="#member.teamId")
    @PutMapping(value={"update"})
    @RequiresPermissions(value={"member:update"})
    public RestResponse update(Member member) {
        this.memberService.updateMember(member);
        return RestResponse.success();
    }
}

