/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.CompletableFutureUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.enums.CheckPointType;
import org.apache.streampark.console.core.enums.Operation;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.mapper.SavePointMapper;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.SavePointService;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.flink.client.FlinkClient;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.util.FlinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class SavePointServiceImpl
extends ServiceImpl<SavePointMapper, SavePoint>
implements SavePointService {
    private static final Logger log = LoggerFactory.getLogger(SavePointServiceImpl.class);
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationConfigService configService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    private static final int CPU_NUM = Math.max(2, Runtime.getRuntime().availableProcessors());
    private final ExecutorService flinkTriggerExecutor = new ThreadPoolExecutor(CPU_NUM, CPU_NUM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-savepoint-trigger"));

    @Override
    public void expire(Long appId) {
        SavePoint savePoint = new SavePoint();
        savePoint.setLatest(false);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)appId);
        this.update(savePoint, (Wrapper)queryWrapper);
    }

    public boolean save(SavePoint entity) {
        this.expire(entity);
        this.expire(entity.getAppId());
        return super.save((Object)entity);
    }

    private void expire(SavePoint entity) {
        int cpThreshold;
        block15: {
            FlinkEnv flinkEnv = this.flinkEnvService.getByAppId(entity.getAppId());
            Application application = (Application)this.applicationService.getById(entity.getAppId());
            Utils.notNull((Object)flinkEnv);
            Utils.notNull((Object)application);
            String numRetainedKey = CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.key();
            String numRetainedFromDynamicProp = (String)PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties()).get(numRetainedKey);
            cpThreshold = 0;
            if (numRetainedFromDynamicProp != null) {
                try {
                    int value = Integer.parseInt(numRetainedFromDynamicProp.trim());
                    if (value > 0) {
                        cpThreshold = value;
                    } else {
                        log.warn("this value of dynamicProperties key: state.checkpoints.num-retained is invalid, must be gt 0");
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("this value of dynamicProperties key: state.checkpoints.num-retained invalid, must be number");
                }
            }
            if (cpThreshold == 0) {
                String flinkConfNumRetained = flinkEnv.getFlinkConfig().getProperty(numRetainedKey);
                int numRetainedDefaultValue = (Integer)CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.defaultValue();
                if (flinkConfNumRetained != null) {
                    try {
                        int value = Integer.parseInt(flinkConfNumRetained.trim());
                        if (value > 0) {
                            cpThreshold = value;
                            break block15;
                        }
                        cpThreshold = numRetainedDefaultValue;
                        log.warn("the value of key: state.checkpoints.num-retained in flink-conf.yaml is invalid, must be gt 0, default value: {} will be use", (Object)numRetainedDefaultValue);
                    }
                    catch (NumberFormatException e) {
                        cpThreshold = numRetainedDefaultValue;
                        log.warn("the value of key: state.checkpoints.num-retained in flink-conf.yaml is invalid, must be number, flink env: {}, default value: {} will be use", (Object)flinkEnv.getFlinkHome(), (Object)flinkConfNumRetained);
                    }
                } else {
                    cpThreshold = numRetainedDefaultValue;
                    log.info("the application: {} is not set {} in dynamicProperties or value is invalid, and flink-conf.yaml is the same problem of flink env: {}, default value: {} will be use.", new Object[]{application.getJobName(), numRetainedKey, flinkEnv.getFlinkHome(), numRetainedDefaultValue});
                }
            }
        }
        if (CheckPointType.CHECKPOINT.equals(CheckPointType.of(entity.getType()))) {
            --cpThreshold;
        }
        if (cpThreshold == 0) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)1);
            this.remove((Wrapper)queryWrapper);
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SavePoint::getTriggerTime}).eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)CheckPointType.CHECKPOINT.get())).orderByDesc(SavePoint::getTriggerTime);
            Page savePointPage = (Page)((SavePointMapper)this.baseMapper).selectPage((IPage)new Page(1L, (long)(cpThreshold + 1)), (Wrapper)queryWrapper);
            if (!savePointPage.getRecords().isEmpty() && savePointPage.getRecords().size() > cpThreshold) {
                SavePoint savePoint = (SavePoint)savePointPage.getRecords().get(cpThreshold - 1);
                LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)1)).lt(SavePoint::getTriggerTime, (Object)savePoint.getTriggerTime());
                this.remove((Wrapper)lambdaQueryWrapper);
            }
        }
    }

    @Override
    public SavePoint getLatest(Long id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)id)).eq(SavePoint::getLatest, (Object)true);
        return (SavePoint)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String getSavePointPath(Application appParam) throws Exception {
        Map<String, String> map;
        ApplicationConfig applicationConfig;
        Application application = (Application)this.applicationService.getById(appParam.getId());
        String savepointPath = (String)PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties()).get(CheckpointingOptions.SAVEPOINT_DIRECTORY.key());
        if (StringUtils.isBlank((CharSequence)savepointPath) && (application.isStreamParkJob() || application.isFlinkSqlJob()) && (applicationConfig = this.configService.getEffective(application.getId())) != null && FlinkUtils.isCheckpointEnabled(map = applicationConfig.readConfig())) {
            savepointPath = map.get(CheckpointingOptions.SAVEPOINT_DIRECTORY.key());
        }
        if (StringUtils.isBlank((CharSequence)savepointPath) && ExecutionMode.isRemoteMode((Integer)application.getExecutionMode())) {
            FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
            Utils.notNull((Object)cluster, (String)String.format("The clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            Map<String, String> config = cluster.getFlinkConfig();
            if (!config.isEmpty()) {
                savepointPath = config.get(CheckpointingOptions.SAVEPOINT_DIRECTORY.key());
            }
        }
        if (StringUtils.isBlank((CharSequence)savepointPath)) {
            FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(application.getVersionId());
            savepointPath = flinkEnv.getFlinkConfig().getProperty(CheckpointingOptions.SAVEPOINT_DIRECTORY.key());
        }
        return savepointPath;
    }

    @Override
    public void trigger(Long appId, @Nullable String savepointPath) {
        log.info("Start to trigger savepoint for app {}", (Object)appId);
        Application application = (Application)this.applicationService.getById(appId);
        ApplicationLog applicationLog = new ApplicationLog();
        applicationLog.setOptionName(Operation.SAVEPOINT.getValue());
        applicationLog.setAppId(application.getId());
        applicationLog.setJobManagerUrl(application.getJobManagerUrl());
        applicationLog.setOptionTime(new Date());
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            applicationLog.setYarnAppId(application.getClusterId());
        }
        if (!application.isKubernetesModeJob()) {
            FlinkAppHttpWatcher.addSavepoint(application.getId());
            application.setOptionState(OptionState.SAVEPOINTING.getValue());
            application.setOptionTime(new Date());
            this.applicationService.updateById(application);
            this.flinkAppHttpWatcher.initialize();
        }
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(application.getVersionId());
        String customSavepoint = this.getFinalSavepointDir(savepointPath, application);
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
        String clusterId = this.getClusterId(application, cluster);
        Map<String, Object> properties = this.tryGetRestProps(application, cluster);
        TriggerSavepointRequest request = new TriggerSavepointRequest(flinkEnv.getFlinkVersion(), application.getExecutionModeEnum(), properties, clusterId, application.getJobId(), customSavepoint, application.getK8sNamespace());
        CompletableFuture<SavepointResponse> savepointFuture = CompletableFuture.supplyAsync(() -> FlinkClient.triggerSavepoint((TriggerSavepointRequest)request), this.flinkTriggerExecutor);
        this.handleSavepointResponseFuture(application, applicationLog, savepointFuture);
    }

    private void handleSavepointResponseFuture(Application application, ApplicationLog applicationLog, CompletableFuture<SavepointResponse> savepointFuture) {
        CompletableFutureUtils.runTimeout(savepointFuture, (long)10L, (TimeUnit)TimeUnit.MINUTES, savepointResponse -> {
            if (savepointResponse != null && savepointResponse.savePointDir() != null) {
                applicationLog.setSuccess(true);
                String savePointDir = savepointResponse.savePointDir();
                log.info("Request savepoint successful, savepointDir: {}", (Object)savePointDir);
            }
        }, e -> {
            log.error("Trigger savepoint for flink job failed.", e);
            String exception = Utils.stringifyException((Throwable)e);
            applicationLog.setException(exception);
            if (!(e instanceof TimeoutException)) {
                applicationLog.setSuccess(false);
            }
        }).whenComplete((t, e) -> {
            this.applicationLogService.save(applicationLog);
            if (!application.isKubernetesModeJob()) {
                application.setOptionState(OptionState.NONE.getValue());
                application.setOptionTime(new Date());
                this.applicationService.update(application);
                this.flinkAppHttpWatcher.cleanSavepoint(application);
                this.flinkAppHttpWatcher.initialize();
            }
        });
    }

    private String getFinalSavepointDir(@Nullable String savepointPath, Application application) {
        String result = savepointPath;
        if (StringUtils.isEmpty((CharSequence)savepointPath)) {
            try {
                result = this.getSavePointPath(application);
            }
            catch (Exception e) {
                throw new ApiAlertException("Error in getting savepoint path for triggering savepoint for app " + application.getId(), e);
            }
        }
        return result;
    }

    @Nonnull
    private Map<String, Object> tryGetRestProps(Application application, FlinkCluster cluster) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (ExecutionMode.isRemoteMode((ExecutionMode)application.getExecutionModeEnum())) {
            Utils.notNull((Object)cluster, (String)String.format("The clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            URI activeAddress = cluster.getRemoteURI();
            properties.put(RestOptions.ADDRESS.key(), activeAddress.getHost());
            properties.put(RestOptions.PORT.key(), activeAddress.getPort());
        }
        return properties;
    }

    private String getClusterId(Application application, FlinkCluster cluster) {
        if (ExecutionMode.isKubernetesMode((Integer)application.getExecutionMode())) {
            return ExecutionMode.isKubernetesSessionMode((Integer)application.getExecutionMode()) ? cluster.getClusterId() : application.getClusterId();
        }
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            if (ExecutionMode.YARN_SESSION.equals((Object)application.getExecutionModeEnum())) {
                Utils.notNull((Object)cluster, (String)String.format("The yarn session clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
                return cluster.getClusterId();
            }
            return application.getClusterId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delete(Long id, Application application) throws InternalException {
        SavePoint savePoint = (SavePoint)this.getById(id);
        try {
            if (CommonUtils.notEmpty(savePoint.getPath()).booleanValue()) {
                application.getFsOperator().delete(savePoint.getPath());
            }
            this.removeById(id);
            return true;
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
    }

    @Override
    public IPage<SavePoint> page(SavePoint savePoint, RestRequest request) {
        request.setSortField("trigger_time");
        Page page = MybatisPager.getPage(request);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)savePoint.getAppId());
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void removeApp(Application application) {
        Long appId = application.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
        try {
            application.getFsOperator().delete(application.getWorkspace().APP_SAVEPOINTS().concat("/").concat(appId.toString()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

