/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.flink.packer.pipeline.BuildPipeline;
import org.apache.streampark.flink.packer.pipeline.BuildResult;
import org.apache.streampark.flink.packer.pipeline.PipeError;
import org.apache.streampark.flink.packer.pipeline.PipeSnapshot;
import org.apache.streampark.flink.packer.pipeline.PipelineStatus;
import org.apache.streampark.flink.packer.pipeline.PipelineStepStatus;
import org.apache.streampark.flink.packer.pipeline.PipelineType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_app_build_pipe")
public class AppBuildPipeline {
    private static final Logger log = LoggerFactory.getLogger(AppBuildPipeline.class);
    @TableId(type=IdType.INPUT)
    private Long appId;
    @TableField(value="pipe_type")
    private Integer pipeTypeCode;
    @TableField(value="pipe_status")
    private Integer pipeStatusCode;
    private Integer curStep;
    private Integer totalStep;
    @TableField(value="steps_status")
    private String stepStatusJson;
    @TableField(value="steps_status_ts")
    private String stepStatusTimestampJson;
    @TableField(value="error")
    private String errorJson;
    @TableField(value="build_result")
    private String buildResultJson;
    private Date modifyTime;

    @Nonnull
    @JsonIgnore
    public PipelineType getPipeType() {
        return PipelineType.of((Integer)this.pipeTypeCode);
    }

    @JsonIgnore
    public AppBuildPipeline setPipeType(@Nonnull PipelineType pipeType) {
        this.pipeTypeCode = pipeType.getCode();
        return this;
    }

    @Nonnull
    @JsonIgnore
    public PipelineStatus getPipelineStatus() {
        return PipelineStatus.of((Integer)this.pipeStatusCode);
    }

    @JsonIgnore
    public AppBuildPipeline setPipeStatus(@Nonnull PipelineStatus pipeStatus) {
        this.pipeStatusCode = pipeStatus.getCode();
        return this;
    }

    @Nonnull
    @JsonIgnore
    public Map<Integer, PipelineStepStatus> getStepStatus() {
        if (StringUtils.isBlank((CharSequence)this.stepStatusJson)) {
            return Collections.emptyMap();
        }
        try {
            return JacksonUtils.read(this.stepStatusJson, new TypeReference<HashMap<Integer, PipelineStepStatus>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusJson={}", (Object)this.stepStatusJson, (Object)e);
            return Collections.emptyMap();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setStepStatus(@Nonnull Map<Integer, PipelineStepStatus> stepStatus) {
        try {
            this.stepStatusJson = JacksonUtils.write(stepStatus);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusMap=({})", (Object)stepStatus.entrySet().stream().map(et -> et.getKey() + "->" + et.getValue()).collect(Collectors.joining(",")), (Object)e);
        }
        return this;
    }

    @Nonnull
    @JsonIgnore
    public Map<Integer, Long> getStepStatusTimestamp() {
        if (StringUtils.isBlank((CharSequence)this.stepStatusTimestampJson)) {
            return Collections.emptyMap();
        }
        try {
            return JacksonUtils.read(this.stepStatusTimestampJson, new TypeReference<HashMap<Integer, Long>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusJson={}", (Object)this.stepStatusTimestampJson, (Object)e);
            return Collections.emptyMap();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setStepStatusTimestamp(@Nonnull Map<Integer, Long> stepStatusSt) {
        try {
            this.stepStatusTimestampJson = JacksonUtils.write(stepStatusSt);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusSt=({})", (Object)stepStatusSt.entrySet().stream().map(et -> et.getKey() + "->" + et.getValue()).collect(Collectors.joining(",")), (Object)e);
        }
        return this;
    }

    @Nonnull
    @JsonIgnore
    public PipeError getError() {
        if (StringUtils.isBlank((CharSequence)this.errorJson)) {
            return PipeError.empty();
        }
        try {
            return JacksonUtils.read(this.errorJson, PipeError.class);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, errorJson={}", (Object)this.errorJson, (Object)e);
            return PipeError.empty();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setError(@Nonnull PipeError error) {
        try {
            this.errorJson = JacksonUtils.write(error);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, error={}", (Object)error, (Object)e);
        }
        return this;
    }

    @JsonIgnore
    public <R extends BuildResult> AppBuildPipeline setBuildResult(@Nonnull R result) {
        try {
            this.buildResultJson = JacksonUtils.write(result);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, buildResult={}", result, (Object)e);
        }
        return this;
    }

    public long calCostSecond() {
        Map<Integer, Long> st = this.getStepStatusTimestamp();
        if (st.isEmpty()) {
            return 0L;
        }
        long max = st.values().stream().max(Long::compareTo).orElse(0L);
        long min = st.values().stream().min(Long::compareTo).orElse(0L);
        return (max - min) / 1000L;
    }

    @Nullable
    @JsonIgnore
    public <R extends BuildResult> R getBuildResult() {
        PipelineType pipeType = this.getPipeType();
        if (pipeType.isUnknown() || this.buildResultJson == null) {
            return null;
        }
        try {
            return (R)((BuildResult)JacksonUtils.read(this.buildResultJson, pipeType.getResultType()));
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, buildResultJson={}", (Object)this.buildResultJson, (Object)e);
            return null;
        }
    }

    public static AppBuildPipeline initFromPipeline(@Nonnull BuildPipeline pipeline) {
        return AppBuildPipeline.fromPipeSnapshot(pipeline.snapshot());
    }

    public static AppBuildPipeline fromPipeSnapshot(@Nonnull PipeSnapshot snapshot) {
        return new AppBuildPipeline().setPipeType(snapshot.pipeType()).setPipeStatus(snapshot.pipeStatus()).setTotalStep(snapshot.allSteps()).setCurStep(snapshot.curStep()).setStepStatus(snapshot.pureStepStatusAsJava()).setStepStatusTimestamp(snapshot.stepStatusTimestampAsJava()).setError(snapshot.error()).setModifyTime(new Date(snapshot.emitTime()));
    }

    public View toView() {
        return View.of(this);
    }

    public Long getAppId() {
        return this.appId;
    }

    public Integer getPipeTypeCode() {
        return this.pipeTypeCode;
    }

    public Integer getPipeStatusCode() {
        return this.pipeStatusCode;
    }

    public Integer getCurStep() {
        return this.curStep;
    }

    public Integer getTotalStep() {
        return this.totalStep;
    }

    public String getStepStatusJson() {
        return this.stepStatusJson;
    }

    public String getStepStatusTimestampJson() {
        return this.stepStatusTimestampJson;
    }

    public String getErrorJson() {
        return this.errorJson;
    }

    public String getBuildResultJson() {
        return this.buildResultJson;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public AppBuildPipeline setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public AppBuildPipeline setPipeTypeCode(Integer pipeTypeCode) {
        this.pipeTypeCode = pipeTypeCode;
        return this;
    }

    public AppBuildPipeline setPipeStatusCode(Integer pipeStatusCode) {
        this.pipeStatusCode = pipeStatusCode;
        return this;
    }

    public AppBuildPipeline setCurStep(Integer curStep) {
        this.curStep = curStep;
        return this;
    }

    public AppBuildPipeline setTotalStep(Integer totalStep) {
        this.totalStep = totalStep;
        return this;
    }

    public AppBuildPipeline setStepStatusJson(String stepStatusJson) {
        this.stepStatusJson = stepStatusJson;
        return this;
    }

    public AppBuildPipeline setStepStatusTimestampJson(String stepStatusTimestampJson) {
        this.stepStatusTimestampJson = stepStatusTimestampJson;
        return this;
    }

    public AppBuildPipeline setErrorJson(String errorJson) {
        this.errorJson = errorJson;
        return this;
    }

    public AppBuildPipeline setBuildResultJson(String buildResultJson) {
        this.buildResultJson = buildResultJson;
        return this;
    }

    public AppBuildPipeline setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
        return this;
    }

    public AppBuildPipeline() {
    }

    public AppBuildPipeline(Long appId, Integer pipeTypeCode, Integer pipeStatusCode, Integer curStep, Integer totalStep, String stepStatusJson, String stepStatusTimestampJson, String errorJson, String buildResultJson, Date modifyTime) {
        this.appId = appId;
        this.pipeTypeCode = pipeTypeCode;
        this.pipeStatusCode = pipeStatusCode;
        this.curStep = curStep;
        this.totalStep = totalStep;
        this.stepStatusJson = stepStatusJson;
        this.stepStatusTimestampJson = stepStatusTimestampJson;
        this.errorJson = errorJson;
        this.buildResultJson = buildResultJson;
        this.modifyTime = modifyTime;
    }

    public static class Step {
        private Integer seq;
        private String desc;
        private Integer status;
        private Date ts;

        public Integer getSeq() {
            return this.seq;
        }

        public String getDesc() {
            return this.desc;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Date getTs() {
            return this.ts;
        }

        public Step setSeq(Integer seq) {
            this.seq = seq;
            return this;
        }

        public Step setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Step setStatus(Integer status) {
            this.status = status;
            return this;
        }

        public Step setTs(Date ts) {
            this.ts = ts;
            return this;
        }
    }

    public static class View {
        private Long appId;
        private Integer pipeType;
        private Integer pipeStatus;
        private Integer curStep;
        private Integer totalStep;
        private Double percent;
        private Long costSec;
        private List<Step> steps;
        private Boolean hasError;
        private String errorSummary;
        private String errorStack;
        private Date updateTime;

        public static View of(@Nonnull AppBuildPipeline pipe) {
            Map stepDesc = pipe.getPipeType().getSteps();
            Map<Integer, PipelineStepStatus> stepStatus = pipe.getStepStatus();
            Map<Integer, Long> stepTs = pipe.getStepStatusTimestamp();
            ArrayList<Step> steps = new ArrayList<Step>(stepDesc.size());
            for (int i = 1; i <= pipe.getPipeType().getSteps().size(); ++i) {
                Step step = new Step().setSeq(i).setDesc(stepDesc.getOrDefault(i, "unknown step")).setStatus(stepStatus.getOrDefault(i, PipelineStepStatus.unknown).getCode());
                Long st = stepTs.get(i);
                if (st != null) {
                    step.setTs(new Date(st));
                }
                steps.add(step);
            }
            return new View().setAppId(pipe.getAppId()).setPipeType(pipe.getPipeTypeCode()).setPipeStatus(pipe.getPipeStatusCode()).setCurStep(pipe.getCurStep()).setTotalStep(pipe.getTotalStep()).setPercent(Utils.calPercent((long)(pipe.getBuildResult() == null ? (long)(pipe.getCurStep() - 1) : (long)pipe.getCurStep().intValue()), (long)pipe.getTotalStep().intValue())).setCostSec(pipe.calCostSecond()).setSteps(steps).setHasError(pipe.getError().nonEmpty()).setErrorSummary(pipe.getError().summary()).setErrorStack(pipe.getError().exceptionStack()).setUpdateTime(pipe.getModifyTime());
        }

        public Long getAppId() {
            return this.appId;
        }

        public Integer getPipeType() {
            return this.pipeType;
        }

        public Integer getPipeStatus() {
            return this.pipeStatus;
        }

        public Integer getCurStep() {
            return this.curStep;
        }

        public Integer getTotalStep() {
            return this.totalStep;
        }

        public Double getPercent() {
            return this.percent;
        }

        public Long getCostSec() {
            return this.costSec;
        }

        public List<Step> getSteps() {
            return this.steps;
        }

        public Boolean getHasError() {
            return this.hasError;
        }

        public String getErrorSummary() {
            return this.errorSummary;
        }

        public String getErrorStack() {
            return this.errorStack;
        }

        public Date getUpdateTime() {
            return this.updateTime;
        }

        public View setAppId(Long appId) {
            this.appId = appId;
            return this;
        }

        public View setPipeType(Integer pipeType) {
            this.pipeType = pipeType;
            return this;
        }

        public View setPipeStatus(Integer pipeStatus) {
            this.pipeStatus = pipeStatus;
            return this;
        }

        public View setCurStep(Integer curStep) {
            this.curStep = curStep;
            return this;
        }

        public View setTotalStep(Integer totalStep) {
            this.totalStep = totalStep;
            return this;
        }

        public View setPercent(Double percent) {
            this.percent = percent;
            return this;
        }

        public View setCostSec(Long costSec) {
            this.costSec = costSec;
            return this;
        }

        public View setSteps(List<Step> steps) {
            this.steps = steps;
            return this;
        }

        public View setHasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public View setErrorSummary(String errorSummary) {
            this.errorSummary = errorSummary;
            return this;
        }

        public View setErrorStack(String errorStack) {
            this.errorStack = errorStack;
            return this;
        }

        public View setUpdateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }
    }
}

