/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.InternalConfigHolder;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.GitUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_project")
public class Project
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Project.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long teamId;
    private String name;
    private String url;
    private String branches;
    private Date lastBuild;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String userName;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String password;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String prvkeyPath;
    private Integer repository;
    private String pom;
    private String buildArgs;
    private String description;
    private Integer buildState;
    private Integer type;
    private Date createTime;
    private Date modifyTime;
    private transient String module;
    private transient String dateFrom;
    private transient String dateTo;
    private transient String appSource;

    @JsonIgnore
    public File getAppSource() {
        File sourcePath;
        if (this.appSource == null) {
            this.appSource = Workspace.PROJECT_LOCAL_PATH();
        }
        if (!(sourcePath = new File(this.appSource)).exists()) {
            sourcePath.mkdirs();
        }
        if (sourcePath.isFile()) {
            throw new IllegalArgumentException("[StreamPark] sourcePath must be directory");
        }
        String branches = this.getBranches() == null ? "main" : this.getBranches();
        String rootName = this.url.replaceAll(".*/|\\.git|\\.svn", "");
        String fullName = rootName.concat("-").concat(branches);
        String path = String.format("%s/%s/%s", sourcePath.getAbsolutePath(), this.getName(), fullName);
        return new File(path);
    }

    @JsonIgnore
    public File getDistHome() {
        return new File(Workspace.APP_LOCAL_DIST(), this.id.toString());
    }

    @JsonIgnore
    public File getGitRepository() {
        File home = this.getAppSource();
        return new File(home, ".git");
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.getAppSource());
        FileUtils.deleteDirectory((File)this.getDistHome());
    }

    @JsonIgnore
    public List<String> getAllBranches() {
        try {
            return GitUtils.getBranchList(this);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    public GitAuthorizedError gitCheck() {
        try {
            GitUtils.getBranchList(this);
            return GitAuthorizedError.SUCCESS;
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (err.contains("not authorized")) {
                return GitAuthorizedError.ERROR;
            }
            if (err.contains("Authentication is required")) {
                return GitAuthorizedError.REQUIRED;
            }
            return GitAuthorizedError.UNKNOW;
        }
    }

    @JsonIgnore
    public boolean isCloned() {
        File repository = this.getGitRepository();
        return repository.exists();
    }

    public void cleanCloned() throws IOException {
        if (this.isCloned()) {
            this.delete();
        }
    }

    @JsonIgnore
    public String getMavenArgs() {
        String setting;
        boolean windows = Utils.isWindows();
        String mvn = windows ? "mvn.cmd" : "mvn";
        String mavenHome = System.getenv("M2_HOME");
        if (mavenHome == null) {
            mavenHome = System.getenv("MAVEN_HOME");
        }
        boolean useWrapper = true;
        if (mavenHome != null) {
            mvn = mavenHome + "/bin/" + mvn;
            try {
                Process process = Runtime.getRuntime().exec(mvn + " --version");
                process.waitFor();
                Utils.required((process.exitValue() == 0 ? 1 : 0) != 0);
                useWrapper = false;
            }
            catch (Exception ignored) {
                log.warn("try using user-installed maven failed, now use maven-wrapper.");
            }
        }
        if (useWrapper) {
            mvn = windows ? WebUtils.getAppHome().concat("/bin/mvnw.cmd") : WebUtils.getAppHome().concat("/bin/mvnw");
        }
        StringBuilder cmdBuffer = new StringBuilder(mvn).append(" clean package -DskipTests ");
        if (StringUtils.isNotBlank((CharSequence)this.buildArgs)) {
            String args = this.getIllegalArgs(this.buildArgs);
            if (args != null) {
                throw new IllegalArgumentException(String.format("Illegal argument: \"%s\" in maven build parameters: %s", args, this.buildArgs));
            }
            cmdBuffer.append(this.buildArgs.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(setting = (String)InternalConfigHolder.get((InternalOption)CommonConfig.MAVEN_SETTINGS_PATH())))) {
            String args = this.getIllegalArgs(setting);
            if (args != null) {
                throw new IllegalArgumentException(String.format("Illegal argument \"%s\" in maven-setting file path: %s", args, setting));
            }
            File file = new File(setting);
            if (file.exists() && file.isFile()) {
                cmdBuffer.append(" --settings ").append(setting);
            } else {
                throw new IllegalArgumentException(String.format("Invalid maven-setting file path \"%s\", the path not exist or is not file", setting));
            }
        }
        return cmdBuffer.toString();
    }

    private String getIllegalArgs(String param) {
        Pattern pattern = Pattern.compile("(`.*?`)|(\\$\\((.*?)\\))");
        Matcher matcher = pattern.matcher(param);
        if (matcher.find()) {
            return matcher.group(1) == null ? matcher.group(2) : matcher.group(1);
        }
        Iterator<String> iterator = Arrays.asList(";", "|", "&", ">").iterator();
        String[] argsList = param.split("\\s+");
        while (iterator.hasNext()) {
            String chr = iterator.next();
            for (String arg : argsList) {
                if (!arg.contains(chr)) continue;
                return arg;
            }
        }
        return null;
    }

    @JsonIgnore
    public String getMavenWorkHome() {
        String buildHome = this.getAppSource().getAbsolutePath();
        if (CommonUtils.notEmpty(this.getPom()).booleanValue()) {
            buildHome = new File(buildHome.concat("/").concat(this.getPom())).getParentFile().getAbsolutePath();
        }
        return buildHome;
    }

    @JsonIgnore
    public String getLog4BuildStart() {
        return String.format("%sproject : %s\nbranches: %s\ncommand : %s\n\n", this.getLogHeader("maven install"), this.getName(), this.getBranches(), this.getMavenArgs());
    }

    @JsonIgnore
    public String getLog4CloneStart() {
        return String.format("%sproject  : %s\nbranches : %s\nworkspace: %s\n\n", this.getLogHeader("git clone"), this.getName(), this.getBranches(), this.getAppSource());
    }

    @JsonIgnore
    private String getLogHeader(String header) {
        return "---------------------------------[ " + header + " ]---------------------------------\n";
    }

    public boolean isHttpRepositoryUrl() {
        return this.url != null && (this.url.trim().startsWith("https://") || this.url.trim().startsWith("http://"));
    }

    public boolean isSshRepositoryUrl() {
        return this.url != null && this.url.trim().startsWith("git@");
    }

    public Long getId() {
        return this.id;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranches() {
        return this.branches;
    }

    public Date getLastBuild() {
        return this.lastBuild;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrvkeyPath() {
        return this.prvkeyPath;
    }

    public Integer getRepository() {
        return this.repository;
    }

    public String getPom() {
        return this.pom;
    }

    public String getBuildArgs() {
        return this.buildArgs;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getBuildState() {
        return this.buildState;
    }

    public Integer getType() {
        return this.type;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getModule() {
        return this.module;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBranches(String branches) {
        this.branches = branches;
    }

    public void setLastBuild(Date lastBuild) {
        this.lastBuild = lastBuild;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrvkeyPath(String prvkeyPath) {
        this.prvkeyPath = prvkeyPath;
    }

    public void setRepository(Integer repository) {
        this.repository = repository;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public void setBuildArgs(String buildArgs) {
        this.buildArgs = buildArgs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuildState(Integer buildState) {
        this.buildState = buildState;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public void setAppSource(String appSource) {
        this.appSource = appSource;
    }
}

