/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.util.Preconditions;

public class VertexParallelismWithSlotSharing
implements VertexParallelism {
    private final Map<JobVertexID, Integer> vertexParallelism;
    private final Collection<SlotSharingSlotAllocator.ExecutionSlotSharingGroupAndSlot> assignments;

    VertexParallelismWithSlotSharing(Map<JobVertexID, Integer> vertexParallelism, Collection<SlotSharingSlotAllocator.ExecutionSlotSharingGroupAndSlot> assignments) {
        this.vertexParallelism = vertexParallelism;
        this.assignments = (Collection)Preconditions.checkNotNull(assignments);
    }

    Iterable<SlotSharingSlotAllocator.ExecutionSlotSharingGroupAndSlot> getAssignments() {
        return this.assignments;
    }

    @Override
    public Map<JobVertexID, Integer> getMaxParallelismForVertices() {
        return this.vertexParallelism;
    }

    @Override
    public int getParallelism(JobVertexID jobVertexId) {
        return this.vertexParallelism.get(jobVertexId);
    }
}

